/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import java.util.List;
import java.util.function.Supplier;
import net.cmr.jurassicrevived.block.entity.custom.EggBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class IncubatedEggBlock
extends Block
implements EntityBlock {
    private final Supplier<? extends EntityType<? extends Mob>> toSpawn;
    private final int hatchSeconds = 60;
    private static final VoxelShape EGG_SHAPE = Block.box((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)4.0, (double)9.5);

    public IncubatedEggBlock(BlockBehaviour.Properties pProperties, Supplier<? extends EntityType<? extends Mob>> toSpawn) {
        super(pProperties);
        this.toSpawn = toSpawn;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return EGG_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return EGG_SHAPE;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            BlockEntity be = level.getBlockEntity(pos);
            if (be instanceof EggBlockEntity) {
                EggBlockEntity eggBE = (EggBlockEntity)be;
                eggBE.resetForNewPlacement(level, 60);
            }
            level.scheduleTick(pos, (Block)this, 1200);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Mob mob;
        BlockEntity be = level.getBlockEntity(pos);
        if (!(be instanceof EggBlockEntity)) {
            return;
        }
        EggBlockEntity eggBE = (EggBlockEntity)be;
        if (eggBE.getSecondsRemaining((Level)level) > 0) {
            level.scheduleTick(pos, (Block)this, eggBE.getSecondsRemaining((Level)level) * 20);
            return;
        }
        super.tick(state, level, pos, random);
        EntityType<? extends Mob> type = this.toSpawn.get();
        if (type != null && (mob = (Mob)type.create((Level)level)) != null) {
            Vec3 spawn = Vec3.atCenterOf((Vec3i)pos);
            mob.moveTo(spawn.x, spawn.y + 0.1, spawn.z, level.random.nextFloat() * 360.0f, 0.0f);
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.TRIGGERED, null);
            if (mob instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)mob;
                ageable.setBaby(true);
            }
            level.addFreshEntity((Entity)mob);
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        level.removeBlock(pos, false);
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity be;
        if (!level.isClientSide && state.getBlock() != newState.getBlock() && (be = level.getBlockEntity(pos)) instanceof EggBlockEntity) {
            EggBlockEntity eggBE = (EggBlockEntity)be;
            eggBE.invalidateTimer();
        }
        super.onRemove(state, level, pos, newState, isMoving);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new EggBlockEntity(pos, state);
    }

    public void appendHoverText(ItemStack pStack, Item.TooltipContext pContext, List<Component> pTootipComponents, TooltipFlag pTooltipFlag) {
        pTootipComponents.add((Component)Component.translatable((String)"tooltip.jurassicrevived.egg.hatches_in", (Object[])new Object[]{60}));
        super.appendHoverText(pStack, pContext, pTootipComponents, pTooltipFlag);
    }
}

