/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.screen.custom.CrateMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CrateBlockEntity
extends BlockEntity
implements MenuProvider {
    private final int size;
    public final ItemStackHandler itemHandler;

    public CrateBlockEntity(BlockPos pos, BlockState state, int size) {
        super((BlockEntityType)ModBlockEntities.CRATE_BE.get(), pos, state);
        this.size = size;
        this.itemHandler = new ItemStackHandler(size){

            protected void onContentsChanged(int slot) {
                CrateBlockEntity.this.setChanged();
            }
        };
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public int getSize() {
        return this.size;
    }

    public IItemHandler getItemHandler(Direction side) {
        return this.itemHandler;
    }

    public void dropContents(Level level, BlockPos pos) {
        SimpleContainer container = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            container.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)level, (BlockPos)pos, (Container)container);
    }

    public int redstoneSignal() {
        int filled = 0;
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            ++filled;
        }
        if (this.itemHandler.getSlots() == 0) {
            return 0;
        }
        return Math.round((float)filled / (float)this.itemHandler.getSlots() * 15.0f);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.putInt("crate.size", this.size);
        tag.put("crate.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        super.saveAdditional(tag, registries);
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("crate.inventory")) {
            this.itemHandler.deserializeNBT(registries, tag.getCompound("crate.inventory"));
        }
    }

    public Component getDisplayName() {
        return Component.translatable((String)(this.size <= 9 ? "block.jurassicrevived.wood_crate" : "block.jurassicrevived.iron_crate"));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory inv, Player player) {
        return new CrateMenu(id, inv, this);
    }
}

