/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.custom.DNAHybridizerBlock;
import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.recipe.DNAHybridizerRecipe;
import net.cmr.jurassicrevived.recipe.DNAHybridizerRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.custom.DNAHybridizerMenu;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DNAHybridizerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(11){

        protected void onContentsChanged(int slot) {
            DNAHybridizerBlockEntity.this.setChanged();
            if (!DNAHybridizerBlockEntity.this.level.isClientSide()) {
                DNAHybridizerBlockEntity.this.level.sendBlockUpdated(DNAHybridizerBlockEntity.this.getBlockPos(), DNAHybridizerBlockEntity.this.getBlockState(), DNAHybridizerBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0, 1, 2, 3, 4, 5, 6, 7 -> stack.is(ModTags.Items.DNA);
                case 8 -> {
                    if (stack.getItem() == ModItems.FROG_DNA.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 9 -> true;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int DNA_SLOT_1 = 0;
    private static final int DNA_SLOT_2 = 1;
    private static final int DNA_SLOT_3 = 2;
    private static final int DNA_SLOT_4 = 3;
    private static final int DNA_SLOT_5 = 4;
    private static final int DNA_SLOT_6 = 5;
    private static final int DNA_SLOT_7 = 6;
    private static final int DNA_SLOT_8 = 7;
    private static final int DNA_SLOT_9 = 8;
    private static final int OUTPUT_SLOT = 9;
    private final EnumMap<Direction, IItemHandler> sidedHandlers = new EnumMap(Direction.class);
    private ItemStack lockedOutput = ItemStack.EMPTY;
    private String lastInputSignature = "";
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 3000;
    private int DEFAULT_MAX_PROGRESS = 3000;
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final IEnergyStorage EXTERNAL_ENERGY_CAP = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return DNAHybridizerBlockEntity.this.ENERGY_STORAGE == null ? 0 : DNAHybridizerBlockEntity.this.ENERGY_STORAGE.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return DNAHybridizerBlockEntity.this.ENERGY_STORAGE == null ? 0 : DNAHybridizerBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return DNAHybridizerBlockEntity.this.ENERGY_STORAGE == null ? 0 : DNAHybridizerBlockEntity.this.ENERGY_STORAGE.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return DNAHybridizerBlockEntity.this.ENERGY_STORAGE != null && DNAHybridizerBlockEntity.this.ENERGY_STORAGE.canReceive();
        }
    };

    public static void clientTick(Level level, BlockPos pos, BlockState state, DNAHybridizerBlockEntity be) {
        if (!level.isClientSide) {
            return;
        }
        boolean lit = state.hasProperty((Property)DNAHybridizerBlock.LIT) && (Boolean)state.getValue((Property)DNAHybridizerBlock.LIT) != false;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    private ModEnergyStorage createEnergyStorage() {
        if (Config.REQUIRE_POWER) {
            return new ModEnergyStorage(64000, (int)ENERGY_TRANSFER_RATE){

                @Override
                public void onEnergyChanged() {
                    DNAHybridizerBlockEntity.this.setChanged();
                    if (DNAHybridizerBlockEntity.this.getLevel() != null) {
                        DNAHybridizerBlockEntity.this.getLevel().sendBlockUpdated(DNAHybridizerBlockEntity.this.getBlockPos(), DNAHybridizerBlockEntity.this.getBlockState(), DNAHybridizerBlockEntity.this.getBlockState(), 3);
                    }
                }
            };
        }
        return null;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (!Config.REQUIRE_POWER) {
            return null;
        }
        return this.EXTERNAL_ENERGY_CAP;
    }

    public DNAHybridizerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.DNA_HYBRIDIZER_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> DNAHybridizerBlockEntity.this.progress;
                    case 1 -> DNAHybridizerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        DNAHybridizerBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        DNAHybridizerBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        return this.sidedHandlers.computeIfAbsent(direction, dir -> new IItemHandler(){

            public int getSlots() {
                return DNAHybridizerBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return DNAHybridizerBlockEntity.this.itemHandler.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot >= 0 && slot <= 8 && DNAHybridizerBlockEntity.this.itemHandler.isItemValid(slot, stack)) {
                    return DNAHybridizerBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 9) {
                    return DNAHybridizerBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return DNAHybridizerBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return slot >= 0 && slot <= 8 && DNAHybridizerBlockEntity.this.itemHandler.isItemValid(slot, stack);
            }
        });
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jurassicrevived.dna_hybridizer");
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return this.progress == 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new DNAHybridizerMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("dna_hybridizer.progress", this.progress);
        tag.putInt("dna_hybridizer.max_progress", this.maxProgress);
        if (Config.REQUIRE_POWER) {
            tag.putInt("dna_hybridizer.energy", this.ENERGY_STORAGE.getEnergyStored());
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        if (Config.REQUIRE_POWER) {
            this.ENERGY_STORAGE.setEnergy(tag.getInt("dna_hybridizer.energy"));
        }
        this.progress = tag.getInt("dna_hybridizer.progress");
        this.maxProgress = tag.getInt("dna_hybridizer.max_progress");
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean canProceed;
        Optional<RecipeHolder<DNAHybridizerRecipe>> recipeOpt;
        if (Config.REQUIRE_POWER) {
            this.pullEnergyFromNeighbors();
        }
        if ((recipeOpt = this.getCurrentRecipe()).isEmpty()) {
            this.resetProgress();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DNAHybridizerBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.lockedOutput = ItemStack.EMPTY;
            this.lastInputSignature = "";
            return;
        }
        String currentSignature = DNAHybridizerBlockEntity.signatureOf(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3), this.itemHandler.getStackInSlot(4), this.itemHandler.getStackInSlot(5), this.itemHandler.getStackInSlot(6), this.itemHandler.getStackInSlot(7), this.itemHandler.getStackInSlot(8));
        if (this.progress == 0 && (this.lockedOutput.isEmpty() || !currentSignature.equals(this.lastInputSignature))) {
            this.lockedOutput = this.determineOutputForCurrentInputs().copy();
            this.lastInputSignature = currentSignature;
        }
        List<Integer> exactMatch = this.findExactUnorderedMatchIndices((DNAHybridizerRecipe)recipeOpt.get().value());
        ItemStack prospectiveOutput = this.lockedOutput.isEmpty() ? this.determineOutputForCurrentInputs() : this.lockedOutput;
        boolean bl = canProceed = exactMatch != null && !prospectiveOutput.isEmpty() && this.canInsertItemIntoOutputSlot(prospectiveOutput) && this.canInsertAmountIntoOutputSlot(prospectiveOutput);
        if (canProceed) {
            if (Config.REQUIRE_POWER && !this.consumeEnergyPerTick(10)) {
                DNAHybridizerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return;
            }
            this.increaseCraftingProgress();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DNAHybridizerBlock.LIT, (Comparable)Boolean.valueOf(true)));
            DNAHybridizerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DNAHybridizerBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.lockedOutput = ItemStack.EMPTY;
                this.lastInputSignature = "";
            }
        } else {
            this.resetProgress();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)DNAHybridizerBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void pullEnergyFromNeighbors() {
        if (!Config.REQUIRE_POWER) {
            return;
        }
        if (this.level == null) {
            return;
        }
        int capacityLeft = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        if (capacityLeft <= 0) {
            return;
        }
        int remaining = Math.min((int)ENERGY_TRANSFER_RATE, capacityLeft);
        if (remaining <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int actuallyExtracted;
            int canAccept;
            int canExtract;
            if (remaining <= 0) break;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            IEnergyStorage source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)dir.getOpposite());
            if (source == null) {
                source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, null);
            }
            if (source == null || (canExtract = source.extractEnergy(remaining, true)) <= 0 || (canAccept = this.ENERGY_STORAGE.receiveEnergy(canExtract, true)) <= 0 || (actuallyExtracted = source.extractEnergy(canAccept, false)) <= 0) continue;
            int actuallyAccepted = this.ENERGY_STORAGE.receiveEnergy(actuallyExtracted, false);
            if (actuallyAccepted < actuallyExtracted) {
                source.receiveEnergy(actuallyExtracted - actuallyAccepted, false);
            }
            remaining -= actuallyAccepted;
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = this.DEFAULT_MAX_PROGRESS;
    }

    private void craftItem() {
        ItemStack output;
        Optional<RecipeHolder<DNAHybridizerRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack itemStack = output = this.lockedOutput.isEmpty() ? ((DNAHybridizerRecipe)recipe.get().value()).output().copy() : this.lockedOutput.copy();
        if (output.isEmpty()) {
            return;
        }
        if (!this.canInsertItemIntoOutputSlot(output) || !this.canInsertAmountIntoOutputSlot(output)) {
            return;
        }
        List<Integer> matchedIndices = this.findExactUnorderedMatchIndices((DNAHybridizerRecipe)recipe.get().value());
        if (matchedIndices == null) {
            return;
        }
        ItemStack current = this.itemHandler.getStackInSlot(9);
        if (current.isEmpty()) {
            this.itemHandler.setStackInSlot(9, output.copy());
        } else if (current.getItem() == output.getItem() && current.getCount() + output.getCount() <= current.getMaxStackSize()) {
            this.itemHandler.setStackInSlot(9, new ItemStack((ItemLike)current.getItem(), current.getCount() + output.getCount()));
        } else {
            return;
        }
        for (int idx : matchedIndices) {
            this.itemHandler.extractItem(idx, 1, false);
        }
    }

    @Nullable
    private List<Integer> findExactUnorderedMatchIndices(DNAHybridizerRecipe recipe) {
        boolean hasCatalyst = recipe.inputs().size() >= 9 && !((Ingredient)recipe.inputs().get(8)).isEmpty();
        ItemStack s9 = this.itemHandler.getStackInSlot(8);
        if (hasCatalyst ? s9.isEmpty() || !((Ingredient)recipe.inputs().get(8)).test(s9) : !s9.isEmpty()) {
            return null;
        }
        ArrayList<Ingredient> required = new ArrayList<Ingredient>();
        for (int i = 0; i < Math.min(8, recipe.inputs().size()); ++i) {
            Ingredient ing = (Ingredient)recipe.inputs().get(i);
            if (ing.isEmpty()) continue;
            required.add(ing);
        }
        if (required.isEmpty()) {
            return null;
        }
        boolean[] used = new boolean[9];
        used[8] = true;
        ArrayList<Integer> matched = new ArrayList<Integer>(required.size());
        for (Ingredient need : required) {
            boolean found = false;
            for (int i = 0; i < 8; ++i) {
                ItemStack stack;
                if (used[i] || (stack = this.itemHandler.getStackInSlot(i)).isEmpty() || !need.test(stack)) continue;
                used[i] = true;
                matched.add(i);
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        for (int i = 0; i < 8; ++i) {
            if (used[i] || this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return null;
        }
        if (hasCatalyst) {
            matched.add(8);
        }
        return matched;
    }

    private void consumeInputsForUnordered(DNAHybridizerRecipe recipe) {
        ArrayList<Ingredient> required = new ArrayList<Ingredient>();
        for (Ingredient ing : recipe.inputs()) {
            if (ing.isEmpty()) continue;
            required.add(ing);
        }
        if (required.isEmpty()) {
            return;
        }
        boolean[] used = new boolean[9];
        block1: for (Ingredient need : required) {
            for (int i = 0; i < 9; ++i) {
                ItemStack inSlot;
                if (used[i] || (inSlot = this.itemHandler.getStackInSlot(i)).isEmpty() || !need.test(inSlot)) continue;
                this.itemHandler.extractItem(i, 1, false);
                used[i] = true;
                continue block1;
            }
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotsEmptyorReceivable() {
        return this.itemHandler.getStackInSlot(9).isEmpty() || this.itemHandler.getStackInSlot(9).getCount() < this.itemHandler.getStackInSlot(9).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<DNAHybridizerRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = this.lockedOutput.isEmpty() ? ((DNAHybridizerRecipe)recipe.get().value()).output() : this.lockedOutput;
        return !output.isEmpty() && this.canInsertAmountIntoOutputSlot(output) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<DNAHybridizerRecipe>> getCurrentRecipe() {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.DNA_HYBRIDIZER_RECIPE_TYPE.get(), (RecipeInput)new DNAHybridizerRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(2), this.itemHandler.getStackInSlot(3), this.itemHandler.getStackInSlot(4), this.itemHandler.getStackInSlot(5), this.itemHandler.getStackInSlot(6), this.itemHandler.getStackInSlot(7), this.itemHandler.getStackInSlot(8)), this.level);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack output) {
        int[] slots;
        int toInsert = output.getCount();
        for (int slot : slots = new int[]{9}) {
            int space;
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!(stack.isEmpty() ? toInsert <= 8 : stack.getItem() == output.getItem() && (space = stack.getMaxStackSize() - stack.getCount()) >= toInsert)) continue;
            return true;
        }
        return false;
    }

    private ItemStack determineOutputForCurrentInputs() {
        Optional<RecipeHolder<DNAHybridizerRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((DNAHybridizerRecipe)recipe.get().value()).output().copy();
    }

    private static String signatureOf(ItemStack s0, ItemStack s1, ItemStack s2, ItemStack s3, ItemStack s4, ItemStack s5, ItemStack s6, ItemStack s7, ItemStack s8) {
        return DNAHybridizerBlockEntity.stackSig(s0) + "#" + DNAHybridizerBlockEntity.stackSig(s1) + "#" + DNAHybridizerBlockEntity.stackSig(s2) + "#" + DNAHybridizerBlockEntity.stackSig(s3) + "#" + DNAHybridizerBlockEntity.stackSig(s4) + "#" + DNAHybridizerBlockEntity.stackSig(s5) + "#" + DNAHybridizerBlockEntity.stackSig(s6) + "#" + DNAHybridizerBlockEntity.stackSig(s7) + "#" + DNAHybridizerBlockEntity.stackSig(s8);
    }

    private static String stackSig(ItemStack s) {
        if (s.isEmpty()) {
            return "empty";
        }
        String id = s.getItem().builtInRegistryHolder().key().location().toString();
        return id + "x" + s.getCount();
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        int[] slots;
        for (int slot : slots = new int[]{9}) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!stack.isEmpty() && stack.getItem() != output.getItem()) continue;
            return true;
        }
        return false;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    private void consumeInputsFor(DNAHybridizerRecipe recipe) {
        NonNullList<Ingredient> req = recipe.inputs();
        int max = Math.min(req.size(), 9);
        for (int i = 0; i < max; ++i) {
            int slotIndex;
            ItemStack inSlot;
            Ingredient ing = (Ingredient)req.get(i);
            if (ing.isEmpty() || (inSlot = this.itemHandler.getStackInSlot(slotIndex = i)).isEmpty() || !ing.test(inSlot)) continue;
            this.itemHandler.extractItem(slotIndex, 1, false);
        }
    }

    private boolean consumeEnergyPerTick(int fe) {
        if (fe <= 0) {
            return true;
        }
        if (this.ENERGY_STORAGE.getEnergyStored() >= fe) {
            this.ENERGY_STORAGE.extractEnergy(fe, false);
            return true;
        }
        return false;
    }
}

