/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class EggBlockEntity
extends BlockEntity {
    private long placedAt = -1L;
    private int totalSeconds = 5;

    public EggBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.EGG_BE.get(), pos, state);
    }

    public void setPlacedAt(long gameTime) {
        this.placedAt = gameTime;
        this.setChanged();
    }

    public void resetForNewPlacement(Level level, int totalSeconds) {
        this.placedAt = level.getGameTime();
        this.totalSeconds = Math.max(1, totalSeconds);
        this.setChanged();
    }

    public void setTotalSeconds(int secs) {
        this.totalSeconds = Math.max(1, secs);
        this.setChanged();
    }

    public int getTotalSeconds() {
        return this.totalSeconds;
    }

    public int getSecondsRemaining(Level level) {
        if (this.placedAt < 0L) {
            return this.totalSeconds;
        }
        long elapsed = level.getGameTime() - this.placedAt;
        long remainingTicks = Math.max(0L, 20L * (long)this.totalSeconds - elapsed);
        return (int)Math.ceil((double)remainingTicks / 20.0);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.putLong("egg.placedAt", this.placedAt);
        tag.putInt("egg.totalSeconds", this.totalSeconds);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        if (tag.contains("egg.placedAt")) {
            this.placedAt = tag.getLong("egg.placedAt");
        }
        if (tag.contains("egg.totalSeconds")) {
            this.totalSeconds = Math.max(1, tag.getInt("egg.totalSeconds"));
        }
    }

    public void onLoad() {
        super.onLoad();
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            int secsRemaining = this.getSecondsRemaining((Level)server);
            if (secsRemaining > 0) {
                server.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), secsRemaining * 20);
            } else {
                server.scheduleTick(this.getBlockPos(), this.getBlockState().getBlock(), 1);
            }
        }
    }

    public void invalidateTimer() {
        this.placedAt = -1L;
        this.setChanged();
    }

    public Component getHatchTooltip(Level level, Player player) {
        int secs = this.getSecondsRemaining(level);
        return Component.translatable((String)"tooltip.jurassicrevived.egg.hatches_in_seconds", (Object[])new Object[]{secs});
    }
}

