/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import java.util.EnumMap;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.custom.EmbryoCalcificationMachineBlock;
import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.recipe.EmbryoCalcificationMachineRecipe;
import net.cmr.jurassicrevived.recipe.EmbryoCalcificationMachineRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.custom.EmbryoCalcificationMachineMenu;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmbryoCalcificationMachineBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            EmbryoCalcificationMachineBlockEntity.this.setChanged();
            if (!EmbryoCalcificationMachineBlockEntity.this.level.isClientSide()) {
                EmbryoCalcificationMachineBlockEntity.this.level.sendBlockUpdated(EmbryoCalcificationMachineBlockEntity.this.getBlockPos(), EmbryoCalcificationMachineBlockEntity.this.getBlockState(), EmbryoCalcificationMachineBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.getItem() == ModItems.TEST_TUBE.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    if (stack.is(ModTags.Items.TISSUES) || stack.getItem() == ModItems.MOSQUITO_IN_AMBER.get()) {
                        yield true;
                    }
                    yield false;
                }
                case 2, 3, 4 -> true;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int SYRINGE_SLOT = 0;
    private static final int EGG_SLOT = 1;
    private static final int OUTPUT_SLOT = 2;
    private final EnumMap<Direction, IItemHandler> sidedHandlers = new EnumMap(Direction.class);
    private ItemStack lockedOutput = ItemStack.EMPTY;
    private String lastInputSignature = "";
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 100;
    private int DEFAULT_MAX_PROGRESS = 100;
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final IEnergyStorage EXTERNAL_ENERGY_CAP = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE == null ? 0 : EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE == null ? 0 : EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE == null ? 0 : EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE != null && EmbryoCalcificationMachineBlockEntity.this.ENERGY_STORAGE.canReceive();
        }
    };

    public static void clientTick(Level level, BlockPos pos, BlockState state, EmbryoCalcificationMachineBlockEntity be) {
        if (!level.isClientSide) {
            return;
        }
        boolean lit = state.hasProperty((Property)EmbryoCalcificationMachineBlock.LIT) && (Boolean)state.getValue((Property)EmbryoCalcificationMachineBlock.LIT) != false;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    private ModEnergyStorage createEnergyStorage() {
        if (Config.REQUIRE_POWER) {
            return new ModEnergyStorage(64000, (int)ENERGY_TRANSFER_RATE){

                @Override
                public void onEnergyChanged() {
                    EmbryoCalcificationMachineBlockEntity.this.setChanged();
                    if (EmbryoCalcificationMachineBlockEntity.this.getLevel() != null) {
                        EmbryoCalcificationMachineBlockEntity.this.getLevel().sendBlockUpdated(EmbryoCalcificationMachineBlockEntity.this.getBlockPos(), EmbryoCalcificationMachineBlockEntity.this.getBlockState(), EmbryoCalcificationMachineBlockEntity.this.getBlockState(), 3);
                    }
                }
            };
        }
        return null;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (!Config.REQUIRE_POWER) {
            return null;
        }
        return this.EXTERNAL_ENERGY_CAP;
    }

    public EmbryoCalcificationMachineBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.EMBRYO_CALCIFICATION_MACHINE_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> EmbryoCalcificationMachineBlockEntity.this.progress;
                    case 1 -> EmbryoCalcificationMachineBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        EmbryoCalcificationMachineBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        EmbryoCalcificationMachineBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        return this.sidedHandlers.computeIfAbsent(direction, dir -> new IItemHandler(){

            public int getSlots() {
                return EmbryoCalcificationMachineBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return EmbryoCalcificationMachineBlockEntity.this.itemHandler.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if ((slot == 0 || slot == 1) && EmbryoCalcificationMachineBlockEntity.this.itemHandler.isItemValid(slot, stack)) {
                    return EmbryoCalcificationMachineBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 2) {
                    return EmbryoCalcificationMachineBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return EmbryoCalcificationMachineBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return (slot == 0 || slot == 1) && EmbryoCalcificationMachineBlockEntity.this.itemHandler.isItemValid(slot, stack);
            }
        });
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jurassicrevived.embryo_calcification_machine");
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return this.progress == 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new EmbryoCalcificationMachineMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("embryo_calcification_machine.progress", this.progress);
        tag.putInt("embryo_calcification_machine.max_progress", this.maxProgress);
        if (Config.REQUIRE_POWER) {
            tag.putInt("embryo_calcification_machine.energy", this.ENERGY_STORAGE.getEnergyStored());
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        if (Config.REQUIRE_POWER) {
            this.ENERGY_STORAGE.setEnergy(tag.getInt("embryo_calcification_machine.energy"));
        }
        this.progress = tag.getInt("embryo_calcification_machine.progress");
        this.maxProgress = tag.getInt("embryo_calcification_machine.max_progress");
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean canOutputNow;
        Optional<RecipeHolder<EmbryoCalcificationMachineRecipe>> recipeOpt;
        if (Config.REQUIRE_POWER) {
            this.pullEnergyFromNeighbors();
        }
        if ((recipeOpt = this.getCurrentRecipe()).isEmpty()) {
            this.resetProgress();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EmbryoCalcificationMachineBlock.LIT, (Comparable)Boolean.valueOf(false)));
            this.lockedOutput = ItemStack.EMPTY;
            this.lastInputSignature = "";
            return;
        }
        String currentSignature = EmbryoCalcificationMachineBlockEntity.signatureOf(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1));
        if (this.progress == 0 && (this.lockedOutput.isEmpty() || !currentSignature.equals(this.lastInputSignature))) {
            this.lockedOutput = ((EmbryoCalcificationMachineRecipe)recipeOpt.get().value()).output().copy();
            this.lastInputSignature = currentSignature;
        }
        ItemStack prospectiveOutput = this.lockedOutput.isEmpty() ? ((EmbryoCalcificationMachineRecipe)recipeOpt.get().value()).output().copy() : this.lockedOutput;
        boolean bl = canOutputNow = !prospectiveOutput.isEmpty() && this.canInsertItemIntoOutputSlot(prospectiveOutput) && this.canInsertAmountIntoOutputSlot(prospectiveOutput);
        if (!prospectiveOutput.isEmpty() && canOutputNow) {
            if (Config.REQUIRE_POWER && !this.consumeEnergyPerTick(10)) {
                EmbryoCalcificationMachineBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return;
            }
            this.increaseCraftingProgress();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EmbryoCalcificationMachineBlock.LIT, (Comparable)Boolean.valueOf(true)));
            EmbryoCalcificationMachineBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EmbryoCalcificationMachineBlock.LIT, (Comparable)Boolean.valueOf(false)));
                this.lockedOutput = ItemStack.EMPTY;
                this.lastInputSignature = "";
            }
        } else {
            this.resetProgress();
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)EmbryoCalcificationMachineBlock.LIT, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void pullEnergyFromNeighbors() {
        if (!Config.REQUIRE_POWER) {
            return;
        }
        if (this.level == null) {
            return;
        }
        int capacityLeft = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        if (capacityLeft <= 0) {
            return;
        }
        int remaining = Math.min((int)ENERGY_TRANSFER_RATE, capacityLeft);
        if (remaining <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int actuallyExtracted;
            int canAccept;
            int canExtract;
            if (remaining <= 0) break;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            IEnergyStorage source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)dir.getOpposite());
            if (source == null) {
                source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, null);
            }
            if (source == null || (canExtract = source.extractEnergy(remaining, true)) <= 0 || (canAccept = this.ENERGY_STORAGE.receiveEnergy(canExtract, true)) <= 0 || (actuallyExtracted = source.extractEnergy(canAccept, false)) <= 0) continue;
            int actuallyAccepted = this.ENERGY_STORAGE.receiveEnergy(actuallyExtracted, false);
            if (actuallyAccepted < actuallyExtracted) {
                source.receiveEnergy(actuallyExtracted - actuallyAccepted, false);
            }
            remaining -= actuallyAccepted;
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = this.DEFAULT_MAX_PROGRESS;
    }

    private void craftItem() {
        int[] slots;
        ItemStack output;
        Optional<RecipeHolder<EmbryoCalcificationMachineRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack itemStack = output = this.lockedOutput.isEmpty() ? ((EmbryoCalcificationMachineRecipe)recipe.get().value()).output().copy() : this.lockedOutput.copy();
        if (output.isEmpty()) {
            return;
        }
        if (!this.canInsertItemIntoOutputSlot(output) || !this.canInsertAmountIntoOutputSlot(output)) {
            return;
        }
        for (int slot : slots = new int[]{2}) {
            ItemStack current = this.itemHandler.getStackInSlot(slot);
            if (current.isEmpty()) {
                this.itemHandler.setStackInSlot(slot, output.copy());
                this.itemHandler.extractItem(0, 1, false);
                this.itemHandler.extractItem(1, 1, false);
                return;
            }
            if (current.getItem() != output.getItem() || current.getCount() + output.getCount() > current.getMaxStackSize()) continue;
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)current.getItem(), current.getCount() + output.getCount()));
            this.itemHandler.extractItem(0, 1, false);
            this.itemHandler.extractItem(1, 1, false);
            return;
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotsEmptyorReceivable() {
        return this.itemHandler.getStackInSlot(2).isEmpty() || this.itemHandler.getStackInSlot(2).getCount() < this.itemHandler.getStackInSlot(2).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<EmbryoCalcificationMachineRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = this.lockedOutput.isEmpty() ? ((EmbryoCalcificationMachineRecipe)recipe.get().value()).output() : this.lockedOutput;
        return !output.isEmpty() && this.canInsertAmountIntoOutputSlot(output) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<EmbryoCalcificationMachineRecipe>> getCurrentRecipe() {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.EMBRYO_CALCIFICATION_MACHINE_RECIPE_TYPE.get(), (RecipeInput)new EmbryoCalcificationMachineRecipeInput(this.itemHandler.getStackInSlot(0), this.itemHandler.getStackInSlot(1)), this.level);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack output) {
        int[] slots;
        int toInsert = output.getCount();
        for (int slot : slots = new int[]{2}) {
            int space;
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!(stack.isEmpty() ? toInsert <= 8 : stack.getItem() == output.getItem() && (space = stack.getMaxStackSize() - stack.getCount()) >= toInsert)) continue;
            return true;
        }
        return false;
    }

    private ItemStack determineOutputForCurrentInputs() {
        Optional<RecipeHolder<EmbryoCalcificationMachineRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return ItemStack.EMPTY;
        }
        return ((EmbryoCalcificationMachineRecipe)recipe.get().value()).output().copy();
    }

    private static String signatureOf(ItemStack test_tube, ItemStack material) {
        return EmbryoCalcificationMachineBlockEntity.stackSig(test_tube) + "#" + EmbryoCalcificationMachineBlockEntity.stackSig(material);
    }

    private static String stackSig(ItemStack s) {
        if (s.isEmpty()) {
            return "empty";
        }
        String id = s.getItem().builtInRegistryHolder().key().location().toString();
        return id + "x" + s.getCount();
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        int[] slots;
        for (int slot : slots = new int[]{2}) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!stack.isEmpty() && stack.getItem() != output.getItem()) continue;
            return true;
        }
        return false;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    private boolean consumeEnergyPerTick(int fe) {
        if (fe <= 0) {
            return true;
        }
        if (this.ENERGY_STORAGE.getEnergyStored() >= fe) {
            this.ENERGY_STORAGE.extractEnergy(fe, false);
            return true;
        }
        return false;
    }
}

