/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import java.util.EnumMap;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.custom.IncubatorBlock;
import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.recipe.IncubatorRecipe;
import net.cmr.jurassicrevived.recipe.IncubatorRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.custom.IncubatorMenu;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IncubatorBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(3){

        protected void onContentsChanged(int slot) {
            IncubatorBlockEntity.this.setChanged();
            if (!IncubatorBlockEntity.this.level.isClientSide()) {
                IncubatorBlockEntity.this.level.sendBlockUpdated(IncubatorBlockEntity.this.getBlockPos(), IncubatorBlockEntity.this.getBlockState(), IncubatorBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return stack.is(ModTags.Items.EGGS);
        }
    };
    private static final int EGG0 = 0;
    private static final int EGG1 = 1;
    private static final int EGG2 = 2;
    private final EnumMap<Direction, IItemHandler> sidedHandlers = new EnumMap(Direction.class);
    private final ContainerData data;
    private final int[] progress = new int[]{0, 0, 0};
    private final int[] maxProgress = new int[]{4800, 4800, 4800};
    private final int DEFAULT_MAX_PROGRESS = 4800;
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private final IEnergyStorage EXTERNAL_ENERGY_CAP = new IEnergyStorage(){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return IncubatorBlockEntity.this.ENERGY_STORAGE == null ? 0 : IncubatorBlockEntity.this.ENERGY_STORAGE.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return IncubatorBlockEntity.this.ENERGY_STORAGE == null ? 0 : IncubatorBlockEntity.this.ENERGY_STORAGE.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return IncubatorBlockEntity.this.ENERGY_STORAGE == null ? 0 : IncubatorBlockEntity.this.ENERGY_STORAGE.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return IncubatorBlockEntity.this.ENERGY_STORAGE != null && IncubatorBlockEntity.this.ENERGY_STORAGE.canReceive();
        }
    };

    public static void clientTick(Level level, BlockPos pos, BlockState state, IncubatorBlockEntity be) {
        if (!level.isClientSide) {
            return;
        }
        boolean lit = state.hasProperty((Property)IncubatorBlock.LIT) && (Boolean)state.getValue((Property)IncubatorBlock.LIT) != false;
    }

    public void setRemoved() {
        super.setRemoved();
    }

    private ModEnergyStorage createEnergyStorage() {
        if (Config.REQUIRE_POWER) {
            return new ModEnergyStorage(64000, (int)ENERGY_TRANSFER_RATE){

                @Override
                public void onEnergyChanged() {
                    IncubatorBlockEntity.this.setChanged();
                    if (IncubatorBlockEntity.this.getLevel() != null) {
                        IncubatorBlockEntity.this.getLevel().sendBlockUpdated(IncubatorBlockEntity.this.getBlockPos(), IncubatorBlockEntity.this.getBlockState(), IncubatorBlockEntity.this.getBlockState(), 3);
                    }
                }
            };
        }
        return null;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (!Config.REQUIRE_POWER) {
            return null;
        }
        return this.EXTERNAL_ENERGY_CAP;
    }

    public IncubatorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.INCUBATOR_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> IncubatorBlockEntity.this.progress[0];
                    case 1 -> IncubatorBlockEntity.this.maxProgress[0];
                    case 2 -> IncubatorBlockEntity.this.progress[1];
                    case 3 -> IncubatorBlockEntity.this.maxProgress[1];
                    case 4 -> IncubatorBlockEntity.this.progress[2];
                    case 5 -> IncubatorBlockEntity.this.maxProgress[2];
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        IncubatorBlockEntity.this.progress[0] = pValue;
                        break;
                    }
                    case 1: {
                        IncubatorBlockEntity.this.maxProgress[0] = pValue;
                        break;
                    }
                    case 2: {
                        IncubatorBlockEntity.this.progress[1] = pValue;
                        break;
                    }
                    case 3: {
                        IncubatorBlockEntity.this.maxProgress[1] = pValue;
                        break;
                    }
                    case 4: {
                        IncubatorBlockEntity.this.progress[2] = pValue;
                        break;
                    }
                    case 5: {
                        IncubatorBlockEntity.this.maxProgress[2] = pValue;
                    }
                }
            }

            public int getCount() {
                return 6;
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        return this.sidedHandlers.computeIfAbsent(direction, dir -> new IItemHandler(){

            public int getSlots() {
                return IncubatorBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return IncubatorBlockEntity.this.itemHandler.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot >= 0 && slot <= 2 && IncubatorBlockEntity.this.itemHandler.isItemValid(slot, stack)) {
                    return IncubatorBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot >= 0 && slot <= 2) {
                    return IncubatorBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return IncubatorBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return slot >= 0 && slot <= 2 && IncubatorBlockEntity.this.itemHandler.isItemValid(slot, stack);
            }
        });
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jurassicrevived.incubator");
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return this.progress[0] == 0 && this.progress[1] == 0 && this.progress[2] == 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new IncubatorMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("incubator.progress0", this.progress[0]);
        tag.putInt("incubator.progress1", this.progress[1]);
        tag.putInt("incubator.progress2", this.progress[2]);
        tag.putInt("incubator.max_progress0", this.maxProgress[0]);
        tag.putInt("incubator.max_progress1", this.maxProgress[1]);
        tag.putInt("incubator.max_progress2", this.maxProgress[2]);
        if (Config.REQUIRE_POWER) {
            tag.putInt("incubator.energy", this.ENERGY_STORAGE.getEnergyStored());
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        if (Config.REQUIRE_POWER) {
            this.ENERGY_STORAGE.setEnergy(tag.getInt("incubator.energy"));
        }
        this.progress[0] = tag.getInt("incubator.progress0");
        this.progress[1] = tag.getInt("incubator.progress1");
        this.progress[2] = tag.getInt("incubator.progress2");
        this.maxProgress[0] = tag.getInt("incubator.max_progress0");
        this.maxProgress[1] = tag.getInt("incubator.max_progress1");
        this.maxProgress[2] = tag.getInt("incubator.max_progress2");
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        Optional<RecipeHolder<IncubatorRecipe>> recipeOpt;
        ItemStack stack;
        int s;
        if (Config.REQUIRE_POWER) {
            this.pullEnergyFromNeighbors();
        }
        boolean changed = false;
        boolean anyActive = false;
        for (s = 0; s < 3; ++s) {
            stack = this.itemHandler.getStackInSlot(s);
            if (stack.isEmpty()) {
                if (this.progress[s] == 0) continue;
                this.progress[s] = 0;
                changed = true;
                continue;
            }
            recipeOpt = this.getRecipeFor(stack);
            if (recipeOpt.isEmpty()) {
                if (this.progress[s] == 0) continue;
                this.progress[s] = 0;
                changed = true;
                continue;
            }
            anyActive = true;
        }
        if ((Boolean)state.getValue((Property)IncubatorBlock.LIT) != anyActive) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)IncubatorBlock.LIT, (Comparable)Boolean.valueOf(anyActive)));
        }
        if (Config.REQUIRE_POWER && anyActive && !this.consumeEnergyPerTick(10)) {
            return;
        }
        for (s = 0; s < 3; ++s) {
            ItemStack out;
            stack = this.itemHandler.getStackInSlot(s);
            if (stack.isEmpty()) continue;
            recipeOpt = this.getRecipeFor(stack);
            if (recipeOpt.isEmpty()) {
                if (this.progress[s] == 0) continue;
                this.progress[s] = 0;
                changed = true;
                continue;
            }
            if (this.progress[s] < this.maxProgress[s]) {
                int n = s;
                this.progress[n] = this.progress[n] + 1;
                changed = true;
            }
            if (this.progress[s] < this.maxProgress[s] || (out = ((IncubatorRecipe)recipeOpt.get().value()).assemble(new IncubatorRecipeInput(stack), (HolderLookup.Provider)level.registryAccess())).isEmpty()) continue;
            this.itemHandler.setStackInSlot(s, out.copy());
            this.progress[s] = 0;
            this.maxProgress[s] = 4800;
            changed = true;
        }
        if (changed) {
            IncubatorBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    private Optional<RecipeHolder<IncubatorRecipe>> getRecipeFor(ItemStack input) {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.INCUBATOR_RECIPE_TYPE.get(), (RecipeInput)new IncubatorRecipeInput(input), this.level);
    }

    private void pullEnergyFromNeighbors() {
        if (!Config.REQUIRE_POWER) {
            return;
        }
        if (this.level == null) {
            return;
        }
        int capacityLeft = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        if (capacityLeft <= 0) {
            return;
        }
        int remaining = Math.min((int)ENERGY_TRANSFER_RATE, capacityLeft);
        if (remaining <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int actuallyExtracted;
            int canAccept;
            int canExtract;
            if (remaining <= 0) break;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            IEnergyStorage source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)dir.getOpposite());
            if (source == null) {
                source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, null);
            }
            if (source == null || (canExtract = source.extractEnergy(remaining, true)) <= 0 || (canAccept = this.ENERGY_STORAGE.receiveEnergy(canExtract, true)) <= 0 || (actuallyExtracted = source.extractEnergy(canAccept, false)) <= 0) continue;
            int actuallyAccepted = this.ENERGY_STORAGE.receiveEnergy(actuallyExtracted, false);
            if (actuallyAccepted < actuallyExtracted) {
                source.receiveEnergy(actuallyExtracted - actuallyAccepted, false);
            }
            remaining -= actuallyAccepted;
        }
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack output) {
        return false;
    }

    private ItemStack determineOutputForCurrentInputs() {
        return ItemStack.EMPTY;
    }

    private static String signatureOf(ItemStack testtube, ItemStack material) {
        return null;
    }

    private static String stackSig(ItemStack s) {
        return null;
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return false;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    private boolean consumeEnergyPerTick(int fe) {
        if (fe <= 0) {
            return true;
        }
        if (this.ENERGY_STORAGE.getEnergyStored() >= fe) {
            this.ENERGY_STORAGE.extractEnergy(fe, false);
            return true;
        }
        return false;
    }
}

