/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.cmr.jurassicrevived.block.custom.PipeBlock;
import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.EmptyFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class PipeBlockEntity
extends BlockEntity {
    private final PipeBlock.Transport transport;
    private static final Map<NetKey, CachedNet<?>> NET_CACHE = new HashMap();

    public PipeBlockEntity(BlockPos pos, BlockState state) {
        super(PipeBlockEntity.resolveType(state), pos, state);
        this.transport = ((PipeBlock)state.getBlock()).getTransport();
    }

    private static BlockEntityType<PipeBlockEntity> resolveType(BlockState state) {
        PipeBlock block = (PipeBlock)state.getBlock();
        return switch (block.getTransport()) {
            default -> throw new MatchException(null, null);
            case PipeBlock.Transport.ITEMS -> ModBlockEntities.ITEM_PIPE_BE.get();
            case PipeBlock.Transport.FLUIDS -> ModBlockEntities.FLUID_PIPE_BE.get();
            case PipeBlock.Transport.ENERGY -> ModBlockEntities.POWER_PIPE_BE.get();
        };
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, PipeBlockEntity be) {
        if (level == null || level.isClientSide) {
            return;
        }
        PipeBlock block = (PipeBlock)state.getBlock();
        int itemCap = block.getMaxItemsPerTick();
        int fluidCap = block.getMaxFluidPerTick();
        int energyCap = block.getMaxEnergyPerTick();
        switch (be.transport) {
            case ITEMS: {
                PipeBlockEntity.transferItems(level, pos, state, itemCap);
                break;
            }
            case FLUIDS: {
                PipeBlockEntity.transferFluids(level, pos, state, fluidCap);
                break;
            }
            case ENERGY: {
                PipeBlockEntity.transferEnergy(level, pos, state, energyCap);
            }
        }
    }

    private static boolean isSamePipe(BlockState state, PipeBlock.Transport transport) {
        PipeBlock pb;
        Block block = state.getBlock();
        return block instanceof PipeBlock && (pb = (PipeBlock)block).getTransport() == transport;
    }

    private static <T> Network<T> discoverNetwork(Level level, BlockPos start, PipeBlock.Transport transport) {
        NetKey key = new NetKey(start, transport);
        CachedNet<?> cached = NET_CACHE.get(key);
        if (cached != null && level.getGameTime() - cached.version <= 20L) {
            return cached.net;
        }
        Network net = new Network();
        ArrayDeque<BlockPos> q = new ArrayDeque<BlockPos>();
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        q.add(start);
        seen.add(start);
        while (!q.isEmpty()) {
            PipeBlock pb;
            BlockPos p = (BlockPos)q.removeFirst();
            BlockState st = level.getBlockState(p);
            Direction[] directionArray = st.getBlock();
            if (!(directionArray instanceof PipeBlock) || (pb = (PipeBlock)directionArray).getTransport() != transport) continue;
            for (Direction d : Direction.values()) {
                BlockState ns;
                BlockPos np;
                PipeBlock.ConnectionType ct = (PipeBlock.ConnectionType)((Object)st.getValue(PipeBlock.getProp(d)));
                if (ct == PipeBlock.ConnectionType.CONNECTOR_PULL) {
                    net.sources.add(new PipeEndpoint(p, d));
                } else if (ct == PipeBlock.ConnectionType.CONNECTOR) {
                    net.sinks.add(new PipeEndpoint(p, d));
                }
                if (ct != PipeBlock.ConnectionType.PIPE || seen.contains(np = p.relative(d)) || !PipeBlockEntity.isSamePipe(ns = level.getBlockState(np), transport)) continue;
                seen.add(np);
                q.add(np);
            }
        }
        NET_CACHE.put(key, new CachedNet(level.getGameTime(), net));
        return net;
    }

    private static void transferItems(Level level, BlockPos pos, BlockState state, int perTickLimit) {
        if (level.isClientSide || perTickLimit <= 0) {
            return;
        }
        PipeBlock.Transport transport = ((PipeBlock)state.getBlock()).getTransport();
        Network net = PipeBlockEntity.discoverNetwork(level, pos, transport);
        ArrayList<IItemHandler> outputs = new ArrayList<IItemHandler>();
        for (PipeEndpoint ep : net.sinks) {
            BlockPos npos = ep.pipePos.relative(ep.side);
            IItemHandler out = PipeBlockEntity.getItemHandler(level, npos, ep.side.getOpposite());
            if (out == null) continue;
            outputs.add(out);
        }
        if (outputs.isEmpty()) {
            return;
        }
        int remaining = perTickLimit;
        int outIndex = (int)(level.getGameTime() % (long)Math.max(1, outputs.size()));
        for (PipeEndpoint ep : net.sources) {
            if (remaining <= 0) break;
            BlockPos npos = ep.pipePos.relative(ep.side);
            IItemHandler src = PipeBlockEntity.getItemHandler(level, npos, ep.side.getOpposite());
            if (src == null) continue;
            for (int slot = 0; slot < src.getSlots() && remaining > 0; ++slot) {
                ItemStack extractedSim = src.extractItem(slot, Math.min(remaining, 64), true);
                if (extractedSim.isEmpty()) continue;
                int tries = outputs.size();
                while (tries-- > 0 && remaining > 0 && !extractedSim.isEmpty()) {
                    IItemHandler out = (IItemHandler)outputs.get(outIndex);
                    outIndex = (outIndex + 1) % outputs.size();
                    ItemStack toInsert = extractedSim.copy();
                    toInsert.setCount(Math.min(toInsert.getCount(), remaining));
                    ItemStack remainder = ItemHandlerHelper.insertItem((IItemHandler)out, (ItemStack)toInsert, (boolean)true);
                    int accepted = toInsert.getCount() - remainder.getCount();
                    if (accepted <= 0) continue;
                    ItemStack actuallyExtracted = src.extractItem(slot, accepted, false);
                    ItemStack leftover = ItemHandlerHelper.insertItem((IItemHandler)out, (ItemStack)actuallyExtracted, (boolean)false);
                    if (!leftover.isEmpty()) {
                        ItemHandlerHelper.insertItem((IItemHandler)src, (ItemStack)leftover, (boolean)false);
                    }
                    remaining -= accepted;
                    extractedSim.shrink(accepted);
                }
            }
        }
    }

    private static IItemHandler getItemHandler(Level level, BlockPos bePos, Direction face) {
        IItemHandler ih = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, bePos, (Object)face);
        if (ih != null) {
            return ih;
        }
        BlockEntity be = level.getBlockEntity(bePos);
        if (be instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity base = (BaseContainerBlockEntity)be;
            BaseContainerBlockEntity inv = base;
            if (inv instanceof WorldlyContainer) {
                WorldlyContainer sided = (WorldlyContainer)inv;
                return new SidedInvWrapper(sided, face);
            }
            return new InvWrapper((Container)inv);
        }
        return null;
    }

    private static void transferFluids(Level level, BlockPos pos, BlockState state, int perTickLimit) {
        if (level.isClientSide || perTickLimit <= 0) {
            return;
        }
        PipeBlock.Transport transport = ((PipeBlock)state.getBlock()).getTransport();
        Network net = PipeBlockEntity.discoverNetwork(level, pos, transport);
        ArrayList<IFluidHandler> outputs = new ArrayList<IFluidHandler>();
        for (PipeEndpoint ep : net.sinks) {
            Direction face;
            BlockPos npos = ep.pipePos.relative(ep.side);
            IFluidHandler out = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, npos, (Object)(face = ep.side.getOpposite()));
            if (out == null) {
                out = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, npos, null);
            }
            if (out == null || out instanceof EmptyFluidHandler) continue;
            outputs.add(out);
        }
        if (outputs.isEmpty()) {
            return;
        }
        int outIndexBase = (int)(level.getGameTime() % (long)Math.max(1, outputs.size()));
        for (PipeEndpoint ep : net.sources) {
            Direction face;
            int remaining = perTickLimit;
            if (remaining <= 0) break;
            BlockPos npos = ep.pipePos.relative(ep.side);
            IFluidHandler src = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, npos, (Object)(face = ep.side.getOpposite()));
            if (src == null) {
                src = (IFluidHandler)level.getCapability(Capabilities.FluidHandler.BLOCK, npos, null);
            }
            if (src == null) continue;
            int outIndex = outIndexBase;
            for (int tank = 0; tank < src.getTanks() && remaining > 0; ++tank) {
                FluidStack available = src.drain(new FluidStack(src.getFluidInTank(tank).getFluidHolder(), remaining), IFluidHandler.FluidAction.SIMULATE);
                if (available.isEmpty()) continue;
                int tries = outputs.size();
                while (tries-- > 0 && remaining > 0 && !available.isEmpty()) {
                    IFluidHandler out = (IFluidHandler)outputs.get(outIndex);
                    outIndex = (outIndex + 1) % outputs.size();
                    FluidStack toSend = available.copy();
                    toSend.setAmount(Math.min(toSend.getAmount(), remaining));
                    int accepted = out.fill(toSend, IFluidHandler.FluidAction.SIMULATE);
                    if (accepted <= 0) continue;
                    FluidStack drained = src.drain(accepted, IFluidHandler.FluidAction.EXECUTE);
                    int filled = out.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                    remaining -= filled;
                    available.shrink(filled);
                }
            }
        }
    }

    private static void transferEnergy(Level level, BlockPos pos, BlockState state, int perTickLimit) {
        if (perTickLimit <= 0) {
            return;
        }
        PipeBlock.Transport transport = ((PipeBlock)state.getBlock()).getTransport();
        Network net = PipeBlockEntity.discoverNetwork(level, pos, transport);
        ArrayList<IEnergyStorage> outputs = new ArrayList<IEnergyStorage>();
        for (PipeEndpoint ep : net.sinks) {
            BlockPos npos = ep.pipePos.relative(ep.side);
            BlockEntity be = level.getBlockEntity(npos);
            if (be == null) continue;
            Direction face = ep.side.getOpposite();
            IEnergyStorage out = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, npos, (Object)face);
            if (out == null) {
                out = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, npos, null);
            }
            if (out == null) continue;
            outputs.add(out);
        }
        if (outputs.isEmpty()) {
            return;
        }
        int outIndexBase = (int)(level.getGameTime() % (long)Math.max(1, outputs.size()));
        block1: for (PipeEndpoint ep : net.sources) {
            int canExtract;
            Direction face;
            int remaining = perTickLimit;
            if (remaining <= 0) break;
            BlockPos npos = ep.pipePos.relative(ep.side);
            IEnergyStorage src = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, npos, (Object)(face = ep.side.getOpposite()));
            if (src == null) {
                src = (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, npos, null);
            }
            if (src == null) continue;
            int outIndex = outIndexBase;
            while (remaining > 0 && (canExtract = src.extractEnergy(remaining, true)) > 0) {
                int tries = outputs.size();
                boolean movedAny = false;
                while (tries-- > 0 && canExtract > 0) {
                    IEnergyStorage out = (IEnergyStorage)outputs.get(outIndex);
                    outIndex = (outIndex + 1) % outputs.size();
                    int accepted = out.receiveEnergy(canExtract, true);
                    if (accepted <= 0) continue;
                    int actuallyExtracted = src.extractEnergy(accepted, false);
                    int actuallyAccepted = out.receiveEnergy(actuallyExtracted, false);
                    remaining -= actuallyAccepted;
                    canExtract -= actuallyAccepted;
                    movedAny = true;
                }
                if (movedAny) continue;
                continue block1;
            }
        }
    }

    private static final class NetKey {
        final BlockPos root;
        final PipeBlock.Transport transport;

        NetKey(BlockPos root, PipeBlock.Transport transport) {
            this.root = root;
            this.transport = transport;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NetKey)) {
                return false;
            }
            NetKey nk = (NetKey)o;
            return this.root.getX() >> 4 == nk.root.getX() >> 4 && this.root.getY() >> 4 == nk.root.getY() >> 4 && this.root.getZ() >> 4 == nk.root.getZ() >> 4 && this.transport == nk.transport;
        }

        public int hashCode() {
            int cx = this.root.getX() >> 4;
            int cy = this.root.getY() >> 4;
            int cz = this.root.getZ() >> 4;
            int h = 31 * (31 * (31 + cx) + cy) + cz;
            return 31 * h + this.transport.hashCode();
        }
    }

    private static final class CachedNet<T> {
        final long version;
        final Network<T> net;

        CachedNet(long version, Network<T> net) {
            this.version = version;
            this.net = net;
        }
    }

    private static class Network<T> {
        final List<PipeEndpoint> sources = new ArrayList<PipeEndpoint>();
        final List<PipeEndpoint> sinks = new ArrayList<PipeEndpoint>();

        private Network() {
        }
    }

    private record PipeEndpoint(BlockPos pipePos, Direction side) {
    }
}

