/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.screen.custom.PowerCellMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class PowerCellBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            PowerCellBlockEntity.this.setChanged();
            if (!PowerCellBlockEntity.this.level.isClientSide()) {
                PowerCellBlockEntity.this.level.sendBlockUpdated(PowerCellBlockEntity.this.getBlockPos(), PowerCellBlockEntity.this.getBlockState(), PowerCellBlockEntity.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }
    };
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public PowerCellBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.POWER_CELL_BE.get(), pos, blockState);
    }

    public Component getDisplayName() {
        return Component.literal((String)"Power Cell");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new PowerCellMenu(containerId, playerInventory, this);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.hasEnergyStackInFirstSlot()) {
            this.transferEnergyToTank();
        }
        if (this.hasEnergyHandlerInSecondSlot()) {
            this.transferEnergyFromTankToHandler();
        }
        this.pushEnergyToAboveNeighbour();
    }

    private boolean hasEnergyStackInFirstSlot() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            return false;
        }
        IEnergyStorage itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy == null) {
            return false;
        }
        return itemEnergy.canExtract() && itemEnergy.getEnergyStored() > 0 && this.ENERGY_STORAGE.getEnergyStored() < this.ENERGY_STORAGE.getMaxEnergyStored();
    }

    private void transferEnergyToTank() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        IEnergyStorage itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy == null || !itemEnergy.canExtract()) {
            return;
        }
        int space = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        if (space <= 0) {
            return;
        }
        int toTransfer = (int)Math.min((float)space, ENERGY_TRANSFER_RATE);
        if (toTransfer <= 0) {
            return;
        }
        int extractedSim = itemEnergy.extractEnergy(toTransfer, true);
        if (extractedSim <= 0) {
            return;
        }
        int received = this.ENERGY_STORAGE.receiveEnergy(extractedSim, true);
        if (received <= 0) {
            return;
        }
        int actuallyExtracted = itemEnergy.extractEnergy(received, false);
        if (actuallyExtracted > 0) {
            this.ENERGY_STORAGE.receiveEnergy(actuallyExtracted, false);
        }
    }

    private boolean hasEnergyHandlerInSecondSlot() {
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        if (stack.isEmpty()) {
            return false;
        }
        IEnergyStorage itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy == null) {
            return false;
        }
        return itemEnergy.canReceive() && itemEnergy.getEnergyStored() < itemEnergy.getMaxEnergyStored() && this.ENERGY_STORAGE.getEnergyStored() > 0;
    }

    private void transferEnergyFromTankToHandler() {
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        if (stack.isEmpty()) {
            return;
        }
        IEnergyStorage itemEnergy = (IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM);
        if (itemEnergy == null || !itemEnergy.canReceive()) {
            return;
        }
        int available = this.ENERGY_STORAGE.getEnergyStored();
        if (available <= 0) {
            return;
        }
        int toTransfer = (int)Math.min((float)available, ENERGY_TRANSFER_RATE);
        if (toTransfer <= 0) {
            return;
        }
        int receivedByItem = itemEnergy.receiveEnergy(toTransfer, true);
        if (receivedByItem <= 0) {
            return;
        }
        int actuallyExtracted = this.ENERGY_STORAGE.extractEnergy(receivedByItem, false);
        if (actuallyExtracted > 0) {
            itemEnergy.receiveEnergy(actuallyExtracted, false);
        }
    }

    private void pushEnergyToAboveNeighbour() {
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockPos up = this.worldPosition.above();
        IEnergyStorage target = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, up, (Object)Direction.DOWN);
        if (target == null || !target.canReceive()) {
            return;
        }
        int available = this.ENERGY_STORAGE.getEnergyStored();
        if (available <= 0) {
            return;
        }
        int toSend = (int)Math.min((float)available, ENERGY_TRANSFER_RATE);
        if (toSend <= 0) {
            return;
        }
        int accepted = target.receiveEnergy(toSend, true);
        if (accepted <= 0) {
            return;
        }
        int extracted = this.ENERGY_STORAGE.extractEnergy(accepted, false);
        if (extracted > 0) {
            target.receiveEnergy(extracted, false);
        }
    }

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(256000, (int)ENERGY_TRANSFER_RATE){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                int received = super.receiveEnergy(maxReceive, simulate);
                if (!simulate && received > 0) {
                    this.onEnergyChanged();
                }
                return received;
            }

            public boolean canReceive() {
                return true;
            }

            @Override
            public void onEnergyChanged() {
                PowerCellBlockEntity.this.setChanged();
                if (PowerCellBlockEntity.this.getLevel() != null) {
                    PowerCellBlockEntity.this.getLevel().sendBlockUpdated(PowerCellBlockEntity.this.getBlockPos(), PowerCellBlockEntity.this.getBlockState(), PowerCellBlockEntity.this.getBlockState(), 3);
                }
            }
        };
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("power_cell.inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        pTag.putInt("power_cell.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(pTag, pRegistries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("power_cell.inventory"));
        this.ENERGY_STORAGE.setEnergy(pTag.getInt("power_cell.energy"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        super.onDataPacket(net, pkt, pRegistries);
    }
}

