/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import net.cmr.jurassicrevived.block.entity.ModBlockEntities;
import net.cmr.jurassicrevived.screen.custom.TankMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TankBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TankBlockEntity.this.setChanged();
            if (!TankBlockEntity.this.level.isClientSide()) {
                TankBlockEntity.this.level.sendBlockUpdated(TankBlockEntity.this.getBlockPos(), TankBlockEntity.this.getBlockState(), TankBlockEntity.this.getBlockState(), 3);
            }
        }

        public int getSlotLimit(int slot) {
            return slot == 1 ? 1 : super.getSlotLimit(slot);
        }
    };
    private final FluidTank FLUID_TANK = this.createFluidTank();

    private FluidTank createFluidTank() {
        return new FluidTank(64000){

            protected void onContentsChanged() {
                TankBlockEntity.this.setChanged();
                if (!TankBlockEntity.this.level.isClientSide()) {
                    TankBlockEntity.this.level.sendBlockUpdated(TankBlockEntity.this.getBlockPos(), TankBlockEntity.this.getBlockState(), TankBlockEntity.this.getBlockState(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return true;
            }
        };
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public TankBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.TANK_BE.get(), pos, blockState);
    }

    public FluidStack getFluid() {
        return this.FLUID_TANK.getFluid();
    }

    public IFluidHandler getTank(@Nullable Direction direction) {
        return this.FLUID_TANK;
    }

    public Component getDisplayName() {
        return Component.literal((String)"Tank");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int containerId, Inventory playerInventory, Player player) {
        return new TankMenu(containerId, playerInventory, this);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState) {
        if (this.hasFluidStackInFirstSlot()) {
            this.transferFluidToTank();
        }
        if (this.hasFluidHandlerInSecondSlot()) {
            this.transferFluidFromTankToHandler();
        }
        this.pushFluidToAboveNeighbour();
    }

    private void pushFluidToAboveNeighbour() {
        FluidUtil.getFluidHandler((Level)this.level, (BlockPos)this.worldPosition.above(), null).ifPresent(iFluidHandler -> FluidUtil.tryFluidTransfer((IFluidHandler)iFluidHandler, (IFluidHandler)this.FLUID_TANK, (int)Integer.MAX_VALUE, (boolean)true));
    }

    private void transferFluidFromTankToHandler() {
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)this.itemHandler.getStackInSlot(1), (IFluidHandler)this.FLUID_TANK, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (result.result != ItemStack.EMPTY) {
            this.itemHandler.setStackInSlot(1, result.result);
        }
    }

    private boolean hasFluidHandlerInSecondSlot() {
        return !this.itemHandler.getStackInSlot(1).isEmpty() && this.itemHandler.getStackInSlot(1).getCapability(Capabilities.FluidHandler.ITEM, null) != null && (((IFluidHandlerItem)this.itemHandler.getStackInSlot(1).getCapability(Capabilities.FluidHandler.ITEM, null)).getFluidInTank(0).isEmpty() || FluidUtil.tryFluidTransfer((IFluidHandler)((IFluidHandler)this.itemHandler.getStackInSlot(1).getCapability(Capabilities.FluidHandler.ITEM, null)), (IFluidHandler)this.FLUID_TANK, (int)Integer.MAX_VALUE, (boolean)false) != FluidStack.EMPTY);
    }

    private void transferFluidToTank() {
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)this.itemHandler.getStackInSlot(0), (IFluidHandler)this.FLUID_TANK, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (result.result != ItemStack.EMPTY) {
            this.itemHandler.setStackInSlot(0, result.result);
        }
    }

    private boolean hasFluidStackInFirstSlot() {
        return !this.itemHandler.getStackInSlot(0).isEmpty() && this.itemHandler.getStackInSlot(0).getCapability(Capabilities.FluidHandler.ITEM, null) != null && !((IFluidHandlerItem)this.itemHandler.getStackInSlot(0).getCapability(Capabilities.FluidHandler.ITEM, null)).getFluidInTank(0).isEmpty();
    }

    protected void saveAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        pTag.put("tank.inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        pTag = this.FLUID_TANK.writeToNBT(pRegistries, pTag);
        super.saveAdditional(pTag, pRegistries);
    }

    protected void loadAdditional(CompoundTag pTag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(pTag, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, pTag.getCompound("tank.inventory"));
        this.FLUID_TANK.readFromNBT(pRegistries, pTag);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        return this.saveWithoutMetadata(pRegistries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        super.onDataPacket(net, pkt, pRegistries);
    }
}

