/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.cmr.jurassicrevived.block.entity.custom.TankBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class TankBlockEntityRenderer
implements BlockEntityRenderer<TankBlockEntity> {
    public TankBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TankBlockEntity pBlockEntity, float partialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int packedOverlay) {
        FluidStack fluidStack = pBlockEntity.getFluid();
        if (fluidStack.isEmpty()) {
            return;
        }
        Level level = pBlockEntity.getLevel();
        if (level == null) {
            return;
        }
        BlockPos pos = pBlockEntity.getBlockPos();
        IClientFluidTypeExtensions fluidTypeExtensions = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
        ResourceLocation stillTexture = fluidTypeExtensions.getStillTexture(fluidStack);
        FluidState state = fluidStack.getFluid().defaultFluidState();
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int tintColor = fluidTypeExtensions.getTintColor(state, (BlockAndTintGetter)level, pos);
        float height = (float)pBlockEntity.getTank(null).getFluidInTank(0).getAmount() / (float)pBlockEntity.getTank(null).getTankCapacity(0) * 0.625f + 0.25f;
        VertexConsumer builder = pBuffer.getBuffer(ItemBlockRenderTypes.getRenderLayer((FluidState)state));
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.1f, height, 0.1f, 0.9f, height, 0.9f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), pPackedLight, tintColor);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.1f, 0.0f, 0.1f, 0.9f, height, 0.1f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), pPackedLight, tintColor);
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
        pPoseStack.translate(0.0f, -0.9f, -1.0f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.1f, height, 0.1f, 0.9f, height, 0.9f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), pPackedLight, tintColor);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(180.0f));
        pPoseStack.translate(-1.0f, 0.0f, -1.8f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.1f, 0.0f, 0.9f, 0.9f, height, 0.9f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), pPackedLight, tintColor);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        pPoseStack.translate(-1.0f, 0.0f, 0.0f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.1f, 0.0f, 0.1f, 0.9f, height, 0.1f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), pPackedLight, tintColor);
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.mulPose(Axis.YN.rotationDegrees(90.0f));
        pPoseStack.translate(0.0f, 0.0f, -1.0f);
        TankBlockEntityRenderer.drawQuad(builder, pPoseStack, 0.1f, 0.0f, 0.1f, 0.9f, height, 0.1f, sprite.getU0(), sprite.getV0(), sprite.getU1(), sprite.getV1(), pPackedLight, tintColor);
        pPoseStack.popPose();
    }

    private static void drawVertex(VertexConsumer builder, PoseStack poseStack, float x, float y, float z, float u, float v, int packedLight, int color) {
        builder.addVertex(poseStack.last().pose(), x, y, z).setColor(color).setUv(u, v).setLight(packedLight).setNormal(1.0f, 0.0f, 0.0f);
    }

    private static void drawQuad(VertexConsumer builder, PoseStack poseStack, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, int packedLight, int color) {
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x0, y0, z0, u0, v0, packedLight, color);
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x0, y1, z1, u0, v1, packedLight, color);
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x1, y1, z1, u1, v1, packedLight, color);
        TankBlockEntityRenderer.drawVertex(builder, poseStack, x1, y0, z0, u1, v0, packedLight, color);
    }
}

