/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.recipe.DNAExtractorRecipe;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DNAExtractorRecipeCategory
implements IRecipeCategory<DNAExtractorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"dna_extracting");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/dna_extractor/dna_extractor_gui.png");
    private static final ResourceLocation DNA_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/dna.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    public static final RecipeType<DNAExtractorRecipe> DNA_EXTRACTOR_RECIPE_RECIPE_TYPE = new RecipeType(UID, DNAExtractorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public DNAExtractorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 80).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.DNA_EXTRACTOR.get()));
    }

    public RecipeType<DNAExtractorRecipe> getRecipeType() {
        return DNA_EXTRACTOR_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.jurassicrevived.dna_extractor");
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void draw(DNAExtractorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, 159, 10, 0.0f, 0.0f, 10, 66, 10, 66);
        }
        int fullW = 8;
        int fullH = 16;
        int drawBaseX = 84;
        int drawBaseY = 38;
        int maxTicks = 200;
        long now = System.currentTimeMillis();
        int progress = (int)(now / 50L % (long)maxTicks);
        int visible = Math.min(fullH, Math.max(0, progress * fullH / maxTicks));
        boolean srcU = false;
        int srcV = fullH - visible;
        int drawX = drawBaseX;
        int drawY = drawBaseY + (fullH - visible);
        if (visible > 0) {
            guiGraphics.blit(DNA_TEXTURE, drawX, drawY, (float)srcU, (float)srcV, fullW, visible, fullW, fullH);
        }
        if (Config.REQUIRE_POWER) {
            int barX = 160;
            int barY = 11;
            int barW = 8;
            int barH = 64;
            int requiredFE = 6000;
            int capacityFE = 64000;
            int filled = (int)((float)barH * ((float)requiredFE / (float)capacityFE));
            guiGraphics.fillGradient(barX, barY + (barH - filled), barX + barW, barY + barH, -4909824, -10482944);
            int mx = (int)mouseX;
            int my = (int)mouseY;
            if (mx >= barX && mx < barX + barW && my >= barY && my < barY + barH) {
                List<MutableComponent> tips = List.of(Component.literal((String)"6000 / 64000 FE"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, tips, Optional.empty(), mx, my);
            }
        }
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, DNAExtractorRecipe recipe, IFocusGroup focuses) {
        ClientLevel level;
        boolean isMosquitoRecipe;
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 35).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 80, 7).addIngredients((Ingredient)recipe.getIngredients().get(1));
        ItemStack amber = new ItemStack((ItemLike)ModItems.MOSQUITO_IN_AMBER.get());
        boolean bl = isMosquitoRecipe = recipe.getIngredients().size() > 1 && ((Ingredient)recipe.getIngredients().get(1)).test(amber);
        if (isMosquitoRecipe && (level = Minecraft.getInstance().level) != null) {
            Registry itemRegistry = level.registryAccess().registryOrThrow(Registries.ITEM);
            Optional dnaTagOpt = itemRegistry.getTag(ModTags.Items.DNA);
            List<Object> dnaOutputs = dnaTagOpt.map(holderSet -> holderSet.stream().map(h -> new ItemStack((ItemLike)h.value(), Math.max(1, recipe.getResultItem(null).getCount()))).collect(Collectors.toList())).orElse(List.of());
            dnaOutputs = dnaOutputs.stream().filter(stack -> recipe.getWeightFor(stack.getItem()) > 0).collect(Collectors.toList());
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 63).addItemStacks(dnaOutputs);
            slot.addRichTooltipCallback((view, tooltip) -> {
                Optional opt = view.getDisplayedItemStack();
                if (opt.isPresent()) {
                    int n = recipe.getWeightFor(((ItemStack)opt.get()).getItem());
                }
            });
            return;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 62, 63).addItemStack(recipe.getResultItem(null));
    }
}

