/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import net.cmr.jurassicrevived.block.custom.EggBlock;
import net.cmr.jurassicrevived.block.custom.IncubatedEggBlock;
import net.cmr.jurassicrevived.block.entity.custom.EggBlockEntity;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.ui.ScreenDirection;

@WailaPlugin
public class EggJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation EGG_UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"egg");
    private static final String NBT_SECS = "jr_secs";
    private static final String NBT_TOTAL = "jr_total";

    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(EggJadePlugin.NBT_SECS)) {
                    return;
                }
                int secs = data.getInt(EggJadePlugin.NBT_SECS);
                int total = data.contains(EggJadePlugin.NBT_TOTAL) ? Math.max(1, data.getInt(EggJadePlugin.NBT_TOTAL)) : 5;
                float ratio = Mth.clamp((float)(1.0f - (float)secs / (float)total), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement progress = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(progress);
                tooltip.add((Component)Component.translatable((String)"tooltip.jurassicrevived.egg.hatches_in_seconds", (Object[])new Object[]{secs}).withStyle(ChatFormatting.YELLOW));
            }

            public ResourceLocation getUid() {
                return EGG_UID;
            }
        }, EggBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(EggJadePlugin.NBT_SECS)) {
                    return;
                }
                int secs = data.getInt(EggJadePlugin.NBT_SECS);
                int total = data.contains(EggJadePlugin.NBT_TOTAL) ? Math.max(1, data.getInt(EggJadePlugin.NBT_TOTAL)) : 5;
                float ratio = Mth.clamp((float)(1.0f - (float)secs / (float)total), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement progress = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(progress);
                tooltip.add((Component)Component.translatable((String)"tooltip.jurassicrevived.egg.hatches_in_seconds", (Object[])new Object[]{secs}).withStyle(ChatFormatting.YELLOW));
            }

            public ResourceLocation getUid() {
                return EGG_UID;
            }
        }, IncubatedEggBlock.class);
    }

    public void register(IWailaCommonRegistration reg) {
        reg.registerBlockDataProvider((IServerDataProvider)new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag data, BlockAccessor accessor) {
                BlockEntity be = accessor.getBlockEntity();
                if (be instanceof EggBlockEntity) {
                    EggBlockEntity egg = (EggBlockEntity)be;
                    int secs = egg.getSecondsRemaining(accessor.getLevel());
                    data.putInt(EggJadePlugin.NBT_SECS, secs);
                    data.putInt(EggJadePlugin.NBT_TOTAL, egg.getTotalSeconds());
                }
            }

            public ResourceLocation getUid() {
                return EGG_UID;
            }
        }, EggBlockEntity.class);
    }
}

