/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.recipe.EmbryonicMachineRecipe;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class EmbryonicMachineRecipeCategory
implements IRecipeCategory<EmbryonicMachineRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"embryonic_machining");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/embryonic_machine/embryonic_machine_gui.png");
    private static final ResourceLocation SYRINGE_BAR_REVERSED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/syringe_bar_reversed.png");
    private static final ResourceLocation WHITE_SYRINGE_BAR_REVERSED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/white_syringe_bar_reversed.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    public static final RecipeType<EmbryonicMachineRecipe> EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE = new RecipeType(UID, EmbryonicMachineRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public EmbryonicMachineRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 80).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.EMBRYONIC_MACHINE.get()));
    }

    public RecipeType<EmbryonicMachineRecipe> getRecipeType() {
        return EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.jurassicrevived.embryonic_machine");
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void draw(EmbryonicMachineRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        guiGraphics.blit(SYRINGE_BAR_REVERSED_TEXTURE, 76, 35, 0.0f, 0.0f, 24, 16, 24, 16);
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, 159, 10, 0.0f, 0.0f, 10, 66, 10, 66);
            int barX = 160;
            int barY = 11;
            int barW = 8;
            int barH = 64;
            int maxTicks = 200;
            long now = System.currentTimeMillis();
            int progress = (int)(now / 50L % (long)maxTicks);
            int arrowPixels = 24;
            int progFilled = progress * arrowPixels / maxTicks;
            if (progFilled > 0) {
                guiGraphics.blit(WHITE_SYRINGE_BAR_REVERSED_TEXTURE, 76, 35, 0.0f, 0.0f, progFilled, 16, 24, 16);
            }
            int requiredFE = 2000;
            int capacityFE = 64000;
            int filled = (int)((float)barH * ((float)requiredFE / (float)capacityFE));
            guiGraphics.fillGradient(barX, barY + (barH - filled), barX + barW, barY + barH, -4909824, -10482944);
            int mx = (int)mouseX;
            int my = (int)mouseY;
            if (mx >= barX && mx < barX + barW && my >= barY && my < barY + barH) {
                List<MutableComponent> tips = List.of(Component.literal((String)"2000 / 64000 FE"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, tips, Optional.empty(), mx, my);
            }
        }
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EmbryonicMachineRecipe recipe, IFocusGroup focuses) {
        ClientLevel level;
        boolean isMosquitoRecipe;
        builder.addSlot(RecipeIngredientRole.INPUT, 39, 35).addIngredients((Ingredient)recipe.getIngredients().get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 35).addIngredients((Ingredient)recipe.getIngredients().get(1));
        if (recipe.getIngredients().size() >= 3) {
            builder.addSlot(RecipeIngredientRole.INPUT, 48, 53).addIngredients((Ingredient)recipe.getIngredients().get(2));
        }
        ItemStack amber = new ItemStack((ItemLike)ModItems.MOSQUITO_IN_AMBER.get());
        boolean bl = isMosquitoRecipe = recipe.getIngredients().size() > 1 && ((Ingredient)recipe.getIngredients().get(1)).test(amber);
        if (isMosquitoRecipe && (level = Minecraft.getInstance().level) != null) {
            Registry itemRegistry = level.registryAccess().registryOrThrow(Registries.ITEM);
            Optional dnaTagOpt = itemRegistry.getTag(ModTags.Items.DNA);
            List dnaOutputs = dnaTagOpt.map(holderSet -> holderSet.stream().map(h -> new ItemStack((ItemLike)h.value(), Math.max(1, recipe.getResultItem(null).getCount()))).collect(Collectors.toList())).orElse(List.of());
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 35).addItemStacks(dnaOutputs);
            slot.addRichTooltipCallback((view, tooltip) -> {
                Optional opt = view.getDisplayedItemStack();
                if (opt.isPresent()) {
                    int weight = recipe.getWeightFor(((ItemStack)opt.get()).getItem());
                    tooltip.add((FormattedText)Component.literal((String)("Weight: " + weight)));
                }
            });
            return;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 35).addItemStack(recipe.getResultItem(null));
    }
}

