/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.recipe.FossilGrinderRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class FossilGrinderRecipeCategory
implements IRecipeCategory<FossilGrinderRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"fossil_grinding");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/fossil_grinder/fossil_grinder_gui.png");
    private static final ResourceLocation CUTTING_BLADES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/cutting_blades.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    public static final RecipeType<FossilGrinderRecipe> FOSSIL_GRINDER_RECIPE_RECIPE_TYPE = new RecipeType(UID, FossilGrinderRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public FossilGrinderRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 80).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FOSSIL_GRINDER.get()));
    }

    public RecipeType<FossilGrinderRecipe> getRecipeType() {
        return FOSSIL_GRINDER_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.jurassicrevived.fossil_grinder");
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void draw(FossilGrinderRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        float scale = 1.25f;
        int texSize = 16;
        float baseAngle = (float)(System.currentTimeMillis() % 700L) / 700.0f * ((float)Math.PI * 2);
        BiConsumer<int[], Float> drawBlade = (center, ang) -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)center[0], (float)center[1], 0.0f);
            guiGraphics.pose().scale(1.25f, 1.25f, 1.0f);
            if (ang != null) {
                guiGraphics.pose().mulPose(Axis.ZP.rotation(-ang.floatValue()));
            }
            guiGraphics.pose().translate(-8.0f, -8.0f, 0.0f);
            guiGraphics.blit(CUTTING_BLADES_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
        };
        int x = 0;
        int y = 0;
        int cx1 = x + 89;
        int cy1 = y + 34;
        int cx2 = x + 89;
        int cy2 = y + 52;
        drawBlade.accept(new int[]{cx1, cy1}, Float.valueOf(baseAngle));
        drawBlade.accept(new int[]{cx2, cy2}, Float.valueOf(-baseAngle));
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, 159, 10, 0.0f, 0.0f, 10, 66, 10, 66);
            int barX = 160;
            int barY = 11;
            int barW = 8;
            int barH = 64;
            int requiredFE = 1000;
            int capacityFE = 64000;
            int filled = (int)((float)barH * ((float)requiredFE / (float)capacityFE));
            guiGraphics.fillGradient(barX, barY + (barH - filled), barX + barW, barY + barH, -4909824, -10482944);
            int mx = (int)mouseX;
            int my = (int)mouseY;
            if (mx >= barX && mx < barX + barW && my >= barY && my < barY + barH) {
                List<MutableComponent> tips = List.of(Component.literal((String)"1000 / 64000 FE"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, tips, Optional.empty(), mx, my);
            }
        }
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FossilGrinderRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 35).addIngredients((Ingredient)recipe.getIngredients().get(0));
        if (!recipe.weights().isEmpty()) {
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            for (Map.Entry<ResourceLocation, Integer> entry : recipe.weights().entrySet()) {
                Item item = (Item)BuiltInRegistries.ITEM.get(entry.getKey());
                if (item == null) continue;
                ItemStack stack = new ItemStack((ItemLike)item, Math.max(1, recipe.getResultItem(null).getCount()));
                outputs.add(stack);
            }
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 17).addItemStacks(outputs);
            slot.addRichTooltipCallback((view, tooltip) -> {
                Optional opt = view.getDisplayedItemStack();
                if (opt.isPresent()) {
                    int weight = recipe.getWeightFor(((ItemStack)opt.get()).getItem());
                    tooltip.add((FormattedText)Component.literal((String)("Weight: " + weight)));
                }
            });
            return;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 17).addItemStack(recipe.getResultItem(null));
    }
}

