/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.recipe.IncubatorRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class IncubatorRecipeCategory
implements IRecipeCategory<IncubatorRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"incubating");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/incubator/incubator_gui.png");
    private static final ResourceLocation LANTERN_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/lantern.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    public static final RecipeType<IncubatorRecipe> INCUBATOR_RECIPE_RECIPE_TYPE = new RecipeType(UID, IncubatorRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;

    public IncubatorRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 80).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()));
    }

    public RecipeType<IncubatorRecipe> getRecipeType() {
        return INCUBATOR_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.jurassicrevived.incubator");
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void draw(IncubatorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics g, double mouseX, double mouseY) {
        ItemStack in;
        this.background.draw(g);
        this.renderLanternFill(g, 50);
        this.renderLanternFill(g, 80);
        this.renderLanternFill(g, 110);
        boolean showOutput = (System.currentTimeMillis() / 2000L & 1L) == 1L;
        ItemStack out = recipe.getResultItem(null);
        ItemStack itemStack = recipe.getIngredients().isEmpty() ? ItemStack.EMPTY : (in = ((Ingredient)recipe.getIngredients().get(0)).getItems().length > 0 ? ((Ingredient)recipe.getIngredients().get(0)).getItems()[0] : ItemStack.EMPTY);
        if (!in.isEmpty() || !out.isEmpty()) {
            ItemStack toRender = showOutput && !out.isEmpty() ? out : in;
            this.drawStackIcon(g, toRender, 50, 35);
        }
        if (Config.REQUIRE_POWER) {
            g.blit(POWER_BAR_TEXTURE, 159, 10, 0.0f, 0.0f, 10, 66, 10, 66);
            int barX = 160;
            int barY = 11;
            int barW = 8;
            int barH = 64;
            int requiredFE = 48000;
            int capacityFE = 64000;
            int filled = (int)((float)barH * ((float)requiredFE / (float)capacityFE));
            g.fillGradient(barX, barY + (barH - filled), barX + barW, barY + barH, -4909824, -10482944);
            int mx = (int)mouseX;
            int my = (int)mouseY;
            if (mx >= barX && mx < barX + barW && my >= barY && my < barY + barH) {
                List<MutableComponent> tips = List.of(Component.literal((String)"48000 / 64000 FE"));
                g.renderTooltip(Minecraft.getInstance().font, tips, Optional.empty(), mx, my);
            }
        }
    }

    private void drawStackIcon(GuiGraphics g, ItemStack stack, int x, int y) {
        if (stack.isEmpty()) {
            return;
        }
        g.renderItem(stack, x, y);
        g.renderItemDecorations(Minecraft.getInstance().font, stack, x, y);
    }

    private void renderLanternFill(GuiGraphics g, int slotPixelX) {
        long now = System.currentTimeMillis();
        float t = (float)(now % 10000L) / 10000.0f;
        int l = Mth.ceil((float)(t * 13.0f)) + 1;
        g.blit(LANTERN_TEXTURE, slotPixelX, 16, 0.0f, 0.0f, 16, l, 16, 16);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, IncubatorRecipe recipe, IFocusGroup focuses) {
        Ingredient ing;
        Ingredient ingredient = ing = recipe.getIngredients().isEmpty() ? null : (Ingredient)recipe.getIngredients().get(0);
        if (ing != null) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 50, 35).addIngredients(ing)).addItemStack(recipe.getResultItem(null));
        } else {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 50, 35).addItemStack(recipe.getResultItem(null));
        }
    }
}

