/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.api.runtime.IJeiRuntime;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.compat.DNAAnalyzerRecipeCategory;
import net.cmr.jurassicrevived.compat.DNAExtractorRecipeCategory;
import net.cmr.jurassicrevived.compat.DNAHybridizerRecipeCategory;
import net.cmr.jurassicrevived.compat.EmbryoCalcificationMachineRecipeCategory;
import net.cmr.jurassicrevived.compat.EmbryonicMachineRecipeCategory;
import net.cmr.jurassicrevived.compat.FossilCleanerRecipeCategory;
import net.cmr.jurassicrevived.compat.FossilGrinderRecipeCategory;
import net.cmr.jurassicrevived.compat.IncubatorRecipeCategory;
import net.cmr.jurassicrevived.recipe.DNAAnalyzerRecipe;
import net.cmr.jurassicrevived.recipe.DNAExtractorRecipe;
import net.cmr.jurassicrevived.recipe.DNAHybridizerRecipe;
import net.cmr.jurassicrevived.recipe.EmbryoCalcificationMachineRecipe;
import net.cmr.jurassicrevived.recipe.EmbryonicMachineRecipe;
import net.cmr.jurassicrevived.recipe.FossilCleanerRecipe;
import net.cmr.jurassicrevived.recipe.FossilGrinderRecipe;
import net.cmr.jurassicrevived.recipe.IncubatorRecipe;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.ModMenuTypes;
import net.cmr.jurassicrevived.screen.custom.DNAAnalyzerMenu;
import net.cmr.jurassicrevived.screen.custom.DNAAnalyzerScreen;
import net.cmr.jurassicrevived.screen.custom.DNAExtractorMenu;
import net.cmr.jurassicrevived.screen.custom.DNAExtractorScreen;
import net.cmr.jurassicrevived.screen.custom.DNAHybridizerMenu;
import net.cmr.jurassicrevived.screen.custom.DNAHybridizerScreen;
import net.cmr.jurassicrevived.screen.custom.EmbryoCalcificationMachineMenu;
import net.cmr.jurassicrevived.screen.custom.EmbryoCalcificationMachineScreen;
import net.cmr.jurassicrevived.screen.custom.EmbryonicMachineMenu;
import net.cmr.jurassicrevived.screen.custom.EmbryonicMachineScreen;
import net.cmr.jurassicrevived.screen.custom.FossilCleanerMenu;
import net.cmr.jurassicrevived.screen.custom.FossilCleanerScreen;
import net.cmr.jurassicrevived.screen.custom.FossilGrinderMenu;
import net.cmr.jurassicrevived.screen.custom.FossilGrinderScreen;
import net.cmr.jurassicrevived.screen.custom.IncubatorMenu;
import net.cmr.jurassicrevived.screen.custom.IncubatorScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIJRPlugin
implements IModPlugin {
    @Nullable
    public static IIngredientManager INGREDIENT_MANAGER;

    public ResourceLocation getPluginUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"jei_plugin");
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        INGREDIENT_MANAGER = jeiRuntime.getIngredientManager();
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new DNAExtractorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DNAAnalyzerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FossilGrinderRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new FossilCleanerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new DNAHybridizerRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new EmbryonicMachineRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new EmbryoCalcificationMachineRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new IncubatorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List<DNAExtractorRecipe> dnaExtractorRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DNA_EXTRACTOR_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<DNAAnalyzerRecipe> dnaAnalyzerRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DNA_ANALYZER_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<FossilGrinderRecipe> fossilGrinderRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.FOSSIL_GRINDER_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<FossilCleanerRecipe> fossilCleanerRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.FOSSIL_CLEANER_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<DNAHybridizerRecipe> dnaHybridizerRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.DNA_HYBRIDIZER_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<EmbryonicMachineRecipe> embryonicMachineRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.EMBRYONIC_MACHINE_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<EmbryoCalcificationMachineRecipe> embryoCalcificationMachineRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.EMBRYO_CALCIFICATION_MACHINE_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        List<IncubatorRecipe> incubatorRecipes = recipeManager.getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)ModRecipes.INCUBATOR_RECIPE_TYPE.get()).stream().map(RecipeHolder::value).toList();
        registration.addRecipes(DNAExtractorRecipeCategory.DNA_EXTRACTOR_RECIPE_RECIPE_TYPE, dnaExtractorRecipes);
        registration.addRecipes(DNAAnalyzerRecipeCategory.DNA_ANALYZER_RECIPE_RECIPE_TYPE, dnaAnalyzerRecipes);
        registration.addRecipes(FossilGrinderRecipeCategory.FOSSIL_GRINDER_RECIPE_RECIPE_TYPE, fossilGrinderRecipes);
        registration.addRecipes(FossilCleanerRecipeCategory.FOSSIL_CLEANER_RECIPE_RECIPE_TYPE, fossilCleanerRecipes);
        registration.addRecipes(DNAHybridizerRecipeCategory.DNA_HYBRIDIZER_RECIPE_RECIPE_TYPE, dnaHybridizerRecipes);
        registration.addRecipes(EmbryonicMachineRecipeCategory.EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE, embryonicMachineRecipes);
        registration.addRecipes(EmbryoCalcificationMachineRecipeCategory.EMBRYO_CALCIFICATION_MACHINE_RECIPE_RECIPE_TYPE, embryoCalcificationMachineRecipes);
        registration.addRecipes(IncubatorRecipeCategory.INCUBATOR_RECIPE_RECIPE_TYPE, incubatorRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(DNAExtractorScreen.class, 81, 31, 14, 25, new RecipeType[]{DNAExtractorRecipeCategory.DNA_EXTRACTOR_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(DNAAnalyzerScreen.class, 81, 31, 14, 25, new RecipeType[]{DNAAnalyzerRecipeCategory.DNA_ANALYZER_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(FossilGrinderScreen.class, 80, 25, 18, 36, new RecipeType[]{FossilGrinderRecipeCategory.FOSSIL_GRINDER_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(FossilCleanerScreen.class, 74, 35, 29, 16, new RecipeType[]{FossilCleanerRecipeCategory.FOSSIL_CLEANER_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(DNAHybridizerScreen.class, 105, 35, 24, 16, new RecipeType[]{DNAHybridizerRecipeCategory.DNA_HYBRIDIZER_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(EmbryonicMachineScreen.class, 76, 35, 24, 16, new RecipeType[]{EmbryonicMachineRecipeCategory.EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(EmbryoCalcificationMachineScreen.class, 76, 35, 24, 16, new RecipeType[]{EmbryoCalcificationMachineRecipeCategory.EMBRYO_CALCIFICATION_MACHINE_RECIPE_RECIPE_TYPE});
        registration.addRecipeClickArea(IncubatorScreen.class, 51, 16, 72, 16, new RecipeType[]{IncubatorRecipeCategory.INCUBATOR_RECIPE_RECIPE_TYPE});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_EXTRACTOR.get()), new RecipeType[]{DNAExtractorRecipeCategory.DNA_EXTRACTOR_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_ANALYZER.get()), new RecipeType[]{DNAAnalyzerRecipeCategory.DNA_ANALYZER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FOSSIL_GRINDER.get()), new RecipeType[]{FossilGrinderRecipeCategory.FOSSIL_GRINDER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.FOSSIL_CLEANER.get()), new RecipeType[]{FossilCleanerRecipeCategory.FOSSIL_CLEANER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.DNA_HYBRIDIZER.get()), new RecipeType[]{DNAHybridizerRecipeCategory.DNA_HYBRIDIZER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EMBRYONIC_MACHINE.get()), new RecipeType[]{EmbryonicMachineRecipeCategory.EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.EMBRYO_CALCIFICATION_MACHINE.get()), new RecipeType[]{EmbryoCalcificationMachineRecipeCategory.EMBRYO_CALCIFICATION_MACHINE_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.INCUBATOR.get()), new RecipeType[]{IncubatorRecipeCategory.INCUBATOR_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_DNA_EXTRACTOR.get()), new RecipeType[]{DNAExtractorRecipeCategory.DNA_EXTRACTOR_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_DNA_ANALYZER.get()), new RecipeType[]{DNAAnalyzerRecipeCategory.DNA_ANALYZER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_FOSSIL_GRINDER.get()), new RecipeType[]{FossilGrinderRecipeCategory.FOSSIL_GRINDER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_FOSSIL_CLEANER.get()), new RecipeType[]{FossilCleanerRecipeCategory.FOSSIL_CLEANER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_DNA_HYBRIDIZER.get()), new RecipeType[]{DNAHybridizerRecipeCategory.DNA_HYBRIDIZER_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_EMBRYONIC_MACHINE.get()), new RecipeType[]{EmbryonicMachineRecipeCategory.EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_EMBRYO_CALCIFICATION_MACHINE.get()), new RecipeType[]{EmbryoCalcificationMachineRecipeCategory.EMBRYO_CALCIFICATION_MACHINE_RECIPE_RECIPE_TYPE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModBlocks.WHITE_INCUBATOR.get()), new RecipeType[]{IncubatorRecipeCategory.INCUBATOR_RECIPE_RECIPE_TYPE});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(DNAExtractorMenu.class, (MenuType)ModMenuTypes.DNA_EXTRACTOR_MENU.get(), DNAExtractorRecipeCategory.DNA_EXTRACTOR_RECIPE_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(DNAAnalyzerMenu.class, (MenuType)ModMenuTypes.DNA_ANALYZER_MENU.get(), DNAAnalyzerRecipeCategory.DNA_ANALYZER_RECIPE_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(FossilGrinderMenu.class, (MenuType)ModMenuTypes.FOSSIL_GRINDER_MENU.get(), FossilGrinderRecipeCategory.FOSSIL_GRINDER_RECIPE_RECIPE_TYPE, 36, 1, 0, 36);
        registration.addRecipeTransferHandler(FossilCleanerMenu.class, (MenuType)ModMenuTypes.FOSSIL_CLEANER_MENU.get(), FossilCleanerRecipeCategory.FOSSIL_CLEANER_RECIPE_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(DNAHybridizerMenu.class, (MenuType)ModMenuTypes.DNA_HYBRIDIZER_MENU.get(), DNAHybridizerRecipeCategory.DNA_HYBRIDIZER_RECIPE_RECIPE_TYPE, 36, 9, 0, 36);
        registration.addRecipeTransferHandler(EmbryonicMachineMenu.class, (MenuType)ModMenuTypes.EMBRYONIC_MACHINE_MENU.get(), EmbryonicMachineRecipeCategory.EMBRYONIC_MACHINE_RECIPE_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(EmbryoCalcificationMachineMenu.class, (MenuType)ModMenuTypes.EMBRYO_CALCIFICATION_MACHINE_MENU.get(), EmbryoCalcificationMachineRecipeCategory.EMBRYO_CALCIFICATION_MACHINE_RECIPE_RECIPE_TYPE, 36, 2, 0, 36);
        registration.addRecipeTransferHandler(IncubatorMenu.class, (MenuType)ModMenuTypes.INCUBATOR_MENU.get(), IncubatorRecipeCategory.INCUBATOR_RECIPE_RECIPE_TYPE, 36, 3, 0, 36);
    }
}

