/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import java.lang.reflect.Field;
import net.cmr.jurassicrevived.block.custom.DNAAnalyzerBlock;
import net.cmr.jurassicrevived.block.custom.DNAExtractorBlock;
import net.cmr.jurassicrevived.block.custom.DNAHybridizerBlock;
import net.cmr.jurassicrevived.block.custom.EmbryoCalcificationMachineBlock;
import net.cmr.jurassicrevived.block.custom.EmbryonicMachineBlock;
import net.cmr.jurassicrevived.block.custom.FossilGrinderBlock;
import net.cmr.jurassicrevived.block.custom.IncubatorBlock;
import net.cmr.jurassicrevived.block.entity.custom.DNAAnalyzerBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.DNAExtractorBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.DNAHybridizerBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.EmbryoCalcificationMachineBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.EmbryonicMachineBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.FossilCleanerBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.FossilGrinderBlockEntity;
import net.cmr.jurassicrevived.block.entity.custom.IncubatorBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.ProgressStyle;
import snownee.jade.api.ui.ScreenDirection;

@WailaPlugin
public class MachineJadePlugin
implements IWailaPlugin {
    private static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"machine_progress");
    private static final String NBT_PROGRESS = "jr_progress";
    private static final String NBT_MAX = "jr_max";

    public void registerClient(IWailaClientRegistration reg) {
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, DNAExtractorBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, DNAAnalyzerBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, DNAHybridizerBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, EmbryoCalcificationMachineBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, EmbryonicMachineBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, FossilGrinderBlock.class);
        reg.registerBlockComponent((IComponentProvider)new IBlockComponentProvider(this){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                CompoundTag data = accessor.getServerData();
                if (data == null || !data.contains(MachineJadePlugin.NBT_PROGRESS) || !data.contains(MachineJadePlugin.NBT_MAX)) {
                    return;
                }
                int progress = Math.max(0, data.getInt(MachineJadePlugin.NBT_PROGRESS));
                int max = Math.max(1, data.getInt(MachineJadePlugin.NBT_MAX));
                float ratio = Mth.clamp((float)((float)progress / (float)max), (float)0.0f, (float)1.0f);
                IElementHelper h = IElementHelper.get();
                ProgressStyle style = h.progressStyle().color(-1, -1).direction(ScreenDirection.RIGHT).fitContentX(true).fitContentY(true);
                BoxStyle box = BoxStyle.getNestedBox();
                IElement bar = h.progress(ratio, (Component)Component.empty(), style, box, true);
                tooltip.add(bar);
            }

            public ResourceLocation getUid() {
                return UID;
            }
        }, IncubatorBlock.class);
    }

    public void register(IWailaCommonRegistration reg) {
        IServerDataProvider<BlockAccessor> provider = new IServerDataProvider<BlockAccessor>(this){

            public void appendServerData(CompoundTag data, BlockAccessor accessor) {
                BlockEntity be = accessor.getBlockEntity();
                if (be == null) {
                    return;
                }
                if (be instanceof IncubatorBlockEntity) {
                    IncubatorBlockEntity inc = (IncubatorBlockEntity)be;
                    int[] p = this.getArray((Object)inc, "progress");
                    int[] m = this.getArray((Object)inc, "maxProgress");
                    if (p != null && m != null && p.length == m.length && p.length > 0) {
                        float best = 0.0f;
                        for (int i = 0; i < p.length; ++i) {
                            int max = Math.max(1, m[i]);
                            best = Math.max(best, (float)p[i] / (float)max);
                        }
                        int scaledMax = 1000;
                        int scaledProgress = Math.round(best * (float)scaledMax);
                        this.put(data, scaledProgress, scaledMax);
                    }
                    return;
                }
                int progress = this.getInt(be, "progress");
                int max = Math.max(1, this.getInt(be, "maxProgress"));
                this.put(data, progress, max);
            }

            private void put(CompoundTag data, int progress, int max) {
                data.putInt(MachineJadePlugin.NBT_PROGRESS, progress);
                data.putInt(MachineJadePlugin.NBT_MAX, Math.max(1, max));
            }

            private int getInt(Object be, String field) {
                try {
                    Field f = be.getClass().getDeclaredField(field);
                    f.setAccessible(true);
                    return f.getInt(be);
                }
                catch (Throwable t) {
                    return 0;
                }
            }

            private int[] getArray(Object be, String field) {
                try {
                    Field f = be.getClass().getDeclaredField(field);
                    f.setAccessible(true);
                    return (int[])f.get(be);
                }
                catch (Throwable t) {
                    return null;
                }
            }

            public ResourceLocation getUid() {
                return UID;
            }
        };
        reg.registerBlockDataProvider((IServerDataProvider)provider, DNAExtractorBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, DNAAnalyzerBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, DNAHybridizerBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, EmbryoCalcificationMachineBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, EmbryonicMachineBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, FossilCleanerBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, FossilGrinderBlockEntity.class);
        reg.registerBlockDataProvider((IServerDataProvider)provider, IncubatorBlockEntity.class);
    }
}

