/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;

public class ModPaintingVariantDataProvider
implements DataProvider {
    private final PackOutput packOutput;

    public ModPaintingVariantDataProvider(PackOutput packOutput) {
        this.packOutput = packOutput;
    }

    public CompletableFuture<?> run(CachedOutput cache) {
        LinkedHashMap<String, PV> variants = new LinkedHashMap<String, PV>();
        variants.put("chic", ModPaintingVariantDataProvider.pv(1, 1));
        variants.put("lonely_tree", ModPaintingVariantDataProvider.pv(1, 1));
        variants.put("meg", ModPaintingVariantDataProvider.pv(1, 1));
        variants.put("seeing_eye", ModPaintingVariantDataProvider.pv(1, 1));
        CompletableFuture[] tasks = (CompletableFuture[])variants.entrySet().stream().map(e -> {
            String name = (String)e.getKey();
            PV pv = (PV)e.getValue();
            Path path = this.paintingVariantPath(name);
            JsonObject json = new JsonObject();
            json.addProperty("asset_id", ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)name).toString());
            json.addProperty("height", (Number)pv.height());
            json.addProperty("width", (Number)pv.width());
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)path);
        }).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(tasks);
    }

    private static PV pv(int width, int height) {
        return new PV(width, height);
    }

    private Path paintingVariantPath(String name) {
        return this.packOutput.getOutputFolder().resolve("data").resolve("jurassicrevived").resolve("painting_variant").resolve(name + ".json");
    }

    public String getName() {
        return "Painting Variant Data: jurassicrevived";
    }

    private record PV(int width, int height) {
    }
}

