/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.datagen.custom;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.cmr.jurassicrevived.recipe.DNAAnalyzerRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class DNAAnalyzingRecipeBuilder {
    private Optional<ItemLike> firstItem = Optional.empty();
    private Optional<ItemLike> secondItem = Optional.empty();
    private Optional<Item> resultItem = Optional.empty();
    private final int count;
    private final Map<String, Criterion<?>> criteria;
    private final Map<ResourceLocation, Integer> weights = new HashMap<ResourceLocation, Integer>();

    public DNAAnalyzingRecipeBuilder(ItemLike ingredient, ItemLike secondIngredient, ItemLike result, int count) {
        this.firstItem = Optional.of(ingredient);
        this.secondItem = Optional.of(secondIngredient);
        this.resultItem = Optional.of(result.asItem());
        this.count = count;
        this.criteria = new LinkedHashMap();
    }

    public static DNAAnalyzingRecipeBuilder amberRandomDNAUniform(ItemLike testtube, ItemLike amber, ItemLike placeholderResult, int count) {
        return new DNAAnalyzingRecipeBuilder(testtube, amber, placeholderResult, count);
    }

    public DNAAnalyzingRecipeBuilder addDNAWeight(ItemLike dnaItem, int weight) {
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)dnaItem.asItem());
        if (id != null) {
            this.weights.put(id, weight);
        }
        return this;
    }

    public void save(RecipeOutput output) {
        ResourceLocation resultKey = BuiltInRegistries.ITEM.getKey((Object)this.resultItem.orElseThrow());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)resultKey.getNamespace(), (String)(resultKey.getPath() + "_from_dna_analyzing"));
        this.save(output, id);
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        NonNullList inputs = NonNullList.create();
        inputs.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{this.firstItem.orElseThrow()}));
        inputs.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{this.secondItem.orElseThrow()}));
        ItemStack result = new ItemStack((ItemLike)this.resultItem.orElseThrow(), this.count);
        DNAAnalyzerRecipe recipe = new DNAAnalyzerRecipe((NonNullList<Ingredient>)inputs, result, Map.copyOf(this.weights));
        AdvancementHolder advancementHolder = null;
        if (!this.criteria.isEmpty()) {
            Advancement.Builder builder = output.advancement();
            for (Map.Entry<String, Criterion<?>> e : this.criteria.entrySet()) {
                builder.addCriterion(e.getKey(), e.getValue());
            }
            builder.rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId));
            builder.requirements(AdvancementRequirements.Strategy.OR);
            advancementHolder = builder.build(recipeId.withPrefix("recipes/"));
        }
        output.accept(recipeId, (Recipe)recipe, advancementHolder);
    }

    public DNAAnalyzingRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }
}

