/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.datagen.custom;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.cmr.jurassicrevived.recipe.DNAHybridizerRecipe;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;

public class DNAHybridizingRecipeBuilder {
    private Optional<Item> resultItem = Optional.empty();
    private final int count;
    private final Map<String, Criterion<?>> criteria;
    private final NonNullList<Ingredient> ingredients = NonNullList.create();
    private Optional<ItemLike> catalyst = Optional.empty();

    public DNAHybridizingRecipeBuilder(ItemLike result, int count) {
        this.resultItem = Optional.of(result.asItem());
        this.count = count;
        this.criteria = new LinkedHashMap();
    }

    public static DNAHybridizingRecipeBuilder result(ItemLike result, int count) {
        return new DNAHybridizingRecipeBuilder(result, count);
    }

    public DNAHybridizingRecipeBuilder addIngredient(ItemLike item) {
        if (this.ingredients.size() >= 9) {
            throw new IllegalStateException("DNAHybridizer supports at most 9 input ingredients");
        }
        this.ingredients.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{item}));
        return this;
    }

    public DNAHybridizingRecipeBuilder addIngredient(Ingredient ingredient) {
        if (this.ingredients.size() >= 9) {
            throw new IllegalStateException("DNAHybridizer supports at most 9 input ingredients");
        }
        this.ingredients.add((Object)ingredient);
        return this;
    }

    public DNAHybridizingRecipeBuilder setCatalyst(ItemLike item) {
        this.catalyst = Optional.of(item);
        return this;
    }

    public void save(RecipeOutput output) {
        ResourceLocation resultKey = BuiltInRegistries.ITEM.getKey((Object)this.resultItem.orElseThrow());
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)resultKey.getNamespace(), (String)(resultKey.getPath() + "_from_dna_hybridizing"));
        this.save(output, id);
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException("DNAHybridizingRecipeBuilder requires at least 1 ingredient");
        }
        NonNullList inputs = NonNullList.create();
        inputs.addAll(this.ingredients);
        if (inputs.size() > 8 && this.catalyst.isPresent()) {
            throw new IllegalStateException("When a catalyst is set, at most 8 regular ingredients are allowed (slot 9 is reserved).");
        }
        if (this.catalyst.isPresent()) {
            while (inputs.size() < 8) {
                inputs.add((Object)Ingredient.EMPTY);
            }
            inputs.add((Object)Ingredient.of((ItemLike[])new ItemLike[]{this.catalyst.get()}));
        }
        ItemStack result = new ItemStack((ItemLike)this.resultItem.orElseThrow(), this.count);
        DNAHybridizerRecipe recipe = new DNAHybridizerRecipe((NonNullList<Ingredient>)inputs, result);
        AdvancementHolder advancementHolder = null;
        if (!this.criteria.isEmpty()) {
            Advancement.Builder builder = output.advancement();
            for (Map.Entry<String, Criterion<?>> e : this.criteria.entrySet()) {
                builder.addCriterion(e.getKey(), e.getValue());
            }
            builder.rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId));
            builder.requirements(AdvancementRequirements.Strategy.OR);
            advancementHolder = builder.build(recipeId.withPrefix("recipes/"));
        }
        output.accept(recipeId, (Recipe)recipe, advancementHolder);
    }

    public DNAHybridizingRecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }
}

