/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity;

import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SeatEntity
extends Entity {
    private UUID mountNextTick;
    private int aliveTicks = 0;

    public SeatEntity(EntityType<?> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.noCulling = true;
        this.setInvulnerable(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag tag) {
    }

    protected void addAdditionalSaveData(CompoundTag tag) {
    }

    public void scheduleMount(UUID rider) {
        this.mountNextTick = rider;
        this.aliveTicks = 0;
    }

    public void tick() {
        this.setDeltaMovement(Vec3.ZERO);
        ++this.aliveTicks;
        if (!this.level().isClientSide) {
            Player p;
            if (this.mountNextTick != null && this.aliveTicks >= 2) {
                Entity e = ((ServerLevel)this.level()).getEntity(this.mountNextTick);
                if (e instanceof Player && !(p = (Player)e).isPassenger()) {
                    p.startRiding((Entity)this, true);
                    p.setYRot(this.getYRot());
                    p.setYHeadRot(this.getYRot());
                    p.setXRot(0.0f);
                }
                this.mountNextTick = null;
            }
            if (!this.getPassengers().isEmpty()) {
                Entity rider = (Entity)this.getPassengers().get(0);
                rider.setDeltaMovement(Vec3.ZERO);
                rider.setYRot(this.getYRot());
                rider.setYHeadRot(this.getYRot());
                if (rider instanceof Player) {
                    p = (Player)rider;
                    p.setSprinting(false);
                }
            } else if (this.aliveTicks > 10) {
                this.discard();
                return;
            }
        }
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.setYRot(this.getYRot());
        this.setYHeadRot(this.getYRot());
        super.tick();
    }

    public Vec3 getPassengerRidingPosition(Entity passenger) {
        return new Vec3(0.0, -0.6, 0.0);
    }

    public void onPassengerTurned(Entity passenger) {
        Vec3 attach = this.getPassengerRidingPosition(passenger);
        double x = this.getX() + attach.x;
        double y = this.getY() + attach.y;
        double z = this.getZ() + attach.z;
        if (!this.level().isClientSide) {
            passenger.setPos(x, y, z);
            passenger.setDeltaMovement(Vec3.ZERO);
            passenger.setYRot(this.getYRot());
            passenger.setYHeadRot(this.getYRot());
            passenger.setXRot(0.0f);
        } else {
            passenger.setPos(x, y, z);
        }
    }
}

