/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity.ai;

import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.player.Player;

public class SprintingMeleeAttackGoal
extends MeleeAttackGoal {
    private final LivingEntity entity;

    public SprintingMeleeAttackGoal(PathfinderMob pMob, double pSpeedModifier, boolean pCanUnseenMemory) {
        super(pMob, pSpeedModifier, pCanUnseenMemory);
        this.entity = pMob;
    }

    public boolean canUse() {
        AgeableMob ageableMob;
        if (!super.canUse()) {
            return false;
        }
        PathfinderMob pathfinderMob = this.mob;
        if (pathfinderMob instanceof AgeableMob && (ageableMob = (AgeableMob)pathfinderMob).isBaby()) {
            return false;
        }
        LivingEntity target = this.mob.getTarget();
        return !(target instanceof Player) || this.mob.level().getDifficulty() != Difficulty.PEACEFUL;
    }

    public void start() {
        super.start();
        this.entity.setSprinting(true);
    }

    public void tick() {
        super.tick();
    }

    public void stop() {
        super.stop();
        this.entity.setSprinting(false);
    }
}

