/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.cmr.jurassicrevived.entity.client.GallimimusVariant;
import net.cmr.jurassicrevived.entity.custom.GallimimusEntity;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class GallimimusModel
extends GeoModel<GallimimusEntity> {
    private static final Map<GallimimusVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(GallimimusVariant.class), map -> {
        map.put(GallimimusVariant.MALE, ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/entity/gallimimus.png"));
        map.put(GallimimusVariant.FEMALE, ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/entity/gallimimus_female.png"));
    });
    private float[] appliedYaw = null;
    private float[] appliedRoll = null;

    public ResourceLocation getModelResource(GallimimusEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"geo/gallimimus.geo.json");
    }

    public ResourceLocation getTextureResource(GallimimusEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public ResourceLocation getAnimationResource(GallimimusEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"animations/gallimimus.animation.json");
    }

    public void setCustomAnimations(GallimimusEntity entity, long id, AnimationState<GallimimusEntity> state) {
        super.setCustomAnimations((GeoAnimatable)entity, id, state);
        String[] tailBones = new String[]{"Tailpart1", "Tailpart2", "Tailpart3", "Tailpart4", "Tailpart5", "Tailpart6"};
        int n = tailBones.length;
        if (this.appliedYaw == null || this.appliedYaw.length != n) {
            this.appliedYaw = new float[n];
            this.appliedRoll = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            GeoBone bone;
            if (this.appliedYaw[i] == 0.0f && this.appliedRoll[i] == 0.0f || (bone = this.getAnimationProcessor().getBone(tailBones[i])) == null) continue;
            if (this.appliedYaw[i] != 0.0f) {
                bone.setRotY(bone.getRotY() - this.appliedYaw[i]);
            }
            if (this.appliedRoll[i] != 0.0f) {
                bone.setRotZ(bone.getRotZ() - this.appliedRoll[i]);
            }
            this.appliedYaw[i] = 0.0f;
            this.appliedRoll[i] = 0.0f;
        }
        float sway = entity.getTailSwayOffset(state.getPartialTick());
        float maxYawDeg = 22.0f;
        float swayGain = 1.35f;
        float rollFraction = 0.4f;
        float deg2rad = (float)Math.PI / 180;
        float baseYaw = sway * maxYawDeg * deg2rad;
        float baseRoll = -baseYaw * rollFraction;
        float[] weights = new float[]{1.0f, 0.78f, 0.58f, 0.42f, 0.3f, 0.22f};
        for (int i = 0; i < n; ++i) {
            GeoBone bone = this.getAnimationProcessor().getBone(tailBones[i]);
            if (bone == null) continue;
            float w = weights[i];
            float yaw = baseYaw * w;
            float roll = baseRoll * w;
            bone.setRotY(yaw);
            bone.setRotZ(roll);
            this.appliedYaw[i] = yaw;
            this.appliedRoll[i] = roll;
        }
        GeoBone head = this.getAnimationProcessor().getBone("Neckpart1");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
            float clampedYawDeg = Mth.clamp((float)entityData.netHeadYaw(), (float)-30.0f, (float)30.0f);
            head.setRotY(clampedYawDeg * ((float)Math.PI / 180));
        }
    }
}

