/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.cmr.jurassicrevived.entity.client.OrnitholestesVariant;
import net.cmr.jurassicrevived.entity.custom.OrnitholestesEntity;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OrnitholestesModel
extends GeoModel<OrnitholestesEntity> {
    private static final Map<OrnitholestesVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(OrnitholestesVariant.class), map -> {
        map.put(OrnitholestesVariant.MALE, ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/entity/ornitholestes.png"));
        map.put(OrnitholestesVariant.FEMALE, ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/entity/ornitholestes_female.png"));
    });
    private float[] appliedYaw = null;
    private float[] appliedRoll = null;

    public ResourceLocation getModelResource(OrnitholestesEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"geo/ornitholestes.geo.json");
    }

    public ResourceLocation getTextureResource(OrnitholestesEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public ResourceLocation getAnimationResource(OrnitholestesEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"animations/ornitholestes.animation.json");
    }

    public void setCustomAnimations(OrnitholestesEntity entity, long id, AnimationState<OrnitholestesEntity> state) {
        super.setCustomAnimations((GeoAnimatable)entity, id, state);
        String[] tailBones = new String[]{"TailBASE", "Tail2", "Tail3", "Tail4", "Tail5"};
        int n = tailBones.length;
        if (this.appliedYaw == null || this.appliedYaw.length != n) {
            this.appliedYaw = new float[n];
            this.appliedRoll = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            GeoBone bone;
            if (this.appliedYaw[i] == 0.0f && this.appliedRoll[i] == 0.0f || (bone = this.getAnimationProcessor().getBone(tailBones[i])) == null) continue;
            if (this.appliedYaw[i] != 0.0f) {
                bone.setRotY(bone.getRotY() - this.appliedYaw[i]);
            }
            if (this.appliedRoll[i] != 0.0f) {
                bone.setRotZ(bone.getRotZ() - this.appliedRoll[i]);
            }
            this.appliedYaw[i] = 0.0f;
            this.appliedRoll[i] = 0.0f;
        }
        float sway = entity.getTailSwayOffset(state.getPartialTick());
        float maxYawDeg = 22.0f;
        float swayGain = 1.35f;
        float rollFraction = 0.4f;
        float deg2rad = (float)Math.PI / 180;
        float baseYaw = sway * maxYawDeg * deg2rad;
        float baseRoll = -baseYaw * rollFraction;
        float[] weights = new float[]{1.0f, 0.78f, 0.58f, 0.42f, 0.3f};
        for (int i = 0; i < n; ++i) {
            GeoBone bone = this.getAnimationProcessor().getBone(tailBones[i]);
            if (bone == null) continue;
            float w = weights[i];
            float yaw = baseYaw * w;
            float roll = baseRoll * w;
            bone.setRotY(yaw);
            bone.setRotZ(roll);
            this.appliedYaw[i] = yaw;
            this.appliedRoll[i] = roll;
        }
        GeoBone head = this.getAnimationProcessor().getBone("NeckBase");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
            float clampedYawDeg = Mth.clamp((float)entityData.netHeadYaw(), (float)-30.0f, (float)30.0f);
            head.setRotY(clampedYawDeg * ((float)Math.PI / 180));
        }
    }
}

