/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.cmr.jurassicrevived.entity.client.TitanosaurusVariant;
import net.cmr.jurassicrevived.entity.custom.TitanosaurusEntity;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class TitanosaurusModel
extends GeoModel<TitanosaurusEntity> {
    private static final Map<TitanosaurusVariant, ResourceLocation> LOCATION_BY_VARIANT = (Map)Util.make((Object)Maps.newEnumMap(TitanosaurusVariant.class), map -> {
        map.put(TitanosaurusVariant.MALE, ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/entity/titanosaurus.png"));
        map.put(TitanosaurusVariant.FEMALE, ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/entity/titanosaurus_female.png"));
    });
    private float[] appliedYaw = null;
    private float[] appliedRoll = null;

    public ResourceLocation getModelResource(TitanosaurusEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"geo/titanosaurus.geo.json");
    }

    public ResourceLocation getTextureResource(TitanosaurusEntity animatable) {
        return LOCATION_BY_VARIANT.get((Object)animatable.getVariant());
    }

    public ResourceLocation getAnimationResource(TitanosaurusEntity animatable) {
        return ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"animations/titanosaurus.animation.json");
    }

    public void setCustomAnimations(TitanosaurusEntity entity, long id, AnimationState<TitanosaurusEntity> state) {
        super.setCustomAnimations((GeoAnimatable)entity, id, state);
        String[] tailBones = new String[]{"tail", "tail1", "tail2", "tail3", "tail4", "tail5", "tail6", "tail7"};
        int n = tailBones.length;
        if (this.appliedYaw == null || this.appliedYaw.length != n) {
            this.appliedYaw = new float[n];
            this.appliedRoll = new float[n];
        }
        for (int i = 0; i < n; ++i) {
            GeoBone bone;
            if (this.appliedYaw[i] == 0.0f && this.appliedRoll[i] == 0.0f || (bone = this.getAnimationProcessor().getBone(tailBones[i])) == null) continue;
            if (this.appliedYaw[i] != 0.0f) {
                bone.setRotY(bone.getRotY() - this.appliedYaw[i]);
            }
            if (this.appliedRoll[i] != 0.0f) {
                bone.setRotZ(bone.getRotZ() - this.appliedRoll[i]);
            }
            this.appliedYaw[i] = 0.0f;
            this.appliedRoll[i] = 0.0f;
        }
        float sway = entity.getTailSwayOffset(state.getPartialTick());
        float maxYawDeg = 22.0f;
        float swayGain = 1.35f;
        float rollFraction = 0.4f;
        float deg2rad = (float)Math.PI / 180;
        float baseYaw = sway * maxYawDeg * deg2rad;
        float baseRoll = -baseYaw * rollFraction;
        float[] weights = new float[]{1.0f, 0.78f, 0.58f, 0.42f, 0.3f, 0.22f, 0.16f, 0.12f};
        for (int i = 0; i < n; ++i) {
            GeoBone bone = this.getAnimationProcessor().getBone(tailBones[i]);
            if (bone == null) continue;
            float w = weights[i];
            float yaw = baseYaw * w;
            float roll = baseRoll * w;
            bone.setRotY(yaw);
            bone.setRotZ(roll);
            this.appliedYaw[i] = yaw;
            this.appliedRoll[i] = roll;
        }
        GeoBone head = this.getAnimationProcessor().getBone("neck");
        if (head != null) {
            EntityModelData entityData = (EntityModelData)state.getData(DataTickets.ENTITY_MODEL_DATA);
            float clampedYawDeg = Mth.clamp((float)entityData.netHeadYaw(), (float)-10.0f, (float)10.0f);
            head.setRotY(clampedYawDeg * ((float)Math.PI / 180));
        }
    }
}

