/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.entity.custom;

import net.cmr.jurassicrevived.entity.ModEntities;
import net.cmr.jurassicrevived.entity.ai.SprintingMeleeAttackGoal;
import net.cmr.jurassicrevived.entity.ai.SprintingPanicGoal;
import net.cmr.jurassicrevived.entity.client.MoganopterusVariant;
import net.cmr.jurassicrevived.entity.custom.BrachiosaurusEntity;
import net.cmr.jurassicrevived.sound.ModSounds;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowMobGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

public class MoganopterusEntity
extends Animal
implements GeoEntity,
FlyingAnimal {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.defineId(MoganopterusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> DATA_SYNCED_AGE = SynchedEntityData.defineId(MoganopterusEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private float tailSwayOffset;
    private float tailSwayVelocity;
    private float tailSwayPrev;
    private int mouthAnimCooldown = 0;

    public MoganopterusEntity(EntityType<? extends Animal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new SprintingPanicGoal((PathfinderMob)this, 1.15){

            public boolean canUse() {
                return MoganopterusEntity.this.isBaby() && super.canUse();
            }
        });
        this.goalSelector.addGoal(2, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, BrachiosaurusEntity.class, 20.0f, 1.0, 1.0));
        this.goalSelector.addGoal(4, (Goal)new SprintingMeleeAttackGoal((PathfinderMob)this, 1.1, false));
        this.goalSelector.addGoal(5, (Goal)new BreedGoal((Animal)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                return MoganopterusEntity.this.onGround() && super.canUse();
            }
        });
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0, 20.0f){

            public boolean canUse() {
                boolean isFlying = !MoganopterusEntity.this.onGround();
                return (isFlying || MoganopterusEntity.this.getRandom().nextInt(400) == 0) && super.canUse();
            }

            protected Vec3 getPosition() {
                Vec3 pos = MoganopterusEntity.this.position();
                RandomSource random = MoganopterusEntity.this.getRandom();
                double x = pos.x + (double)((random.nextFloat() * 2.0f - 1.0f) * 32.0f);
                double z = pos.z + (double)((random.nextFloat() * 2.0f - 1.0f) * 32.0f);
                int groundY = MoganopterusEntity.this.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (int)x, (int)z);
                double y = MoganopterusEntity.this.onGround() ? pos.y + 15.0 + (double)random.nextInt(10) : (random.nextFloat() < 0.05f ? (double)groundY : (pos.y > (double)(groundY + 20) ? pos.y - 5.0 - (double)random.nextInt(10) : pos.y + (double)((random.nextFloat() * 2.0f - 1.0f) * 10.0f)));
                if (y < (double)groundY) {
                    y = groundY;
                }
                return new Vec3(x, y, z);
            }
        });
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.goalSelector.addGoal(10, (Goal)new FollowMobGoal((Mob)this, 0.8, 20.0f, 10.0f));
        this.targetSelector.addGoal(11, (Goal)new NearestAttackableTargetGoal((Mob)this, Animal.class, 10, false, false, target -> {
            if (target.getType() == this.getType()) {
                return false;
            }
            if (target instanceof FlyingAnimal) {
                return false;
            }
            boolean isSmallEnough = target.getBbHeight() <= 1.0f && target.getBbWidth() <= 1.0f;
            return isSmallEnough;
        }));
        this.targetSelector.addGoal(12, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(13, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.goalSelector.addGoal(14, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(15, (Goal)new FloatGoal((Mob)this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.createLivingAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.3).add(Attributes.FLYING_SPEED, 0.6).add(Attributes.ARMOR, 0.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.ATTACK_KNOCKBACK, 0.0).add(Attributes.ATTACK_DAMAGE, 8.0);
    }

    protected PathNavigation createNavigation(Level pLevel) {
        FlyingPathNavigation navigation = new FlyingPathNavigation((Mob)this, pLevel);
        navigation.setCanOpenDoors(false);
        navigation.setCanFloat(true);
        navigation.setCanPassDoors(true);
        return navigation;
    }

    public boolean isFlying() {
        return !this.onGround();
    }

    public boolean causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    protected void checkFallDamage(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
    }

    public boolean isFood(ItemStack pStack) {
        return pStack.is(Items.BEEF);
    }

    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel pLevel, AgeableMob pOtherParent) {
        AgeableMob child = (AgeableMob)ModEntities.MOGANOPTERUS.get().create((Level)pLevel);
        if (child instanceof MoganopterusEntity) {
            MoganopterusEntity baby = (MoganopterusEntity)child;
            MoganopterusVariant randomVariant = (MoganopterusVariant)((Object)Util.getRandom((Object[])MoganopterusVariant.values(), (RandomSource)this.random));
            baby.setVariant(randomVariant);
        }
        return child;
    }

    public boolean doHurtTarget(Entity target) {
        Level level;
        boolean hit = super.doHurtTarget(target);
        if (!this.level().isClientSide && hit && target instanceof LivingEntity && (level = this.level()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.triggerAnim("attackController", "attack");
            this.playSound(ModSounds.BEAK_ATTACK.get(), 1.0f, 1.0f);
        }
        return hit;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "Walk/Run/Idle", state -> {
            if (!this.onGround()) {
                return state.setAndContinue(RawAnimation.begin().then("anim.moganopterus.fly", Animation.LoopType.LOOP));
            }
            if (state.isMoving()) {
                return state.setAndContinue(this.isSprinting() ? RawAnimation.begin().then("anim.moganopterus.walk", Animation.LoopType.LOOP) : RawAnimation.begin().then("anim.moganopterus.walk", Animation.LoopType.LOOP));
            }
            return state.setAndContinue(RawAnimation.begin().then("anim.moganopterus.idle", Animation.LoopType.LOOP));
        }));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackController", state -> PlayState.STOP).triggerableAnim("attack", RawAnimation.begin().then("anim.moganopterus.attack", Animation.LoopType.PLAY_ONCE)));
        controllers.add(new AnimationController((GeoAnimatable)this, "mouthController", state -> PlayState.STOP).triggerableAnim("mouth", RawAnimation.begin().then("anim.moganopterus.mouth", Animation.LoopType.PLAY_ONCE)));
    }

    private float getSignedTurnDelta() {
        return Mth.wrapDegrees((float)(this.yBodyRot - this.yBodyRotO));
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.entityData.set(DATA_SYNCED_AGE, (Object)this.getAge());
            AttributeInstance maxHealthAttr = this.getAttribute(Attributes.MAX_HEALTH);
            if (maxHealthAttr != null) {
                double desired;
                double baseAdult = DefaultAttributes.getSupplier((EntityType)this.getType()).getValue(Attributes.MAX_HEALTH);
                double d = desired = this.isBaby() ? baseAdult * 0.1 : baseAdult;
                if (maxHealthAttr.getBaseValue() != desired) {
                    double oldMax = maxHealthAttr.getBaseValue();
                    double healthRatio = this.getHealth() / (float)oldMax;
                    maxHealthAttr.setBaseValue(desired);
                    this.setHealth((float)(desired * Mth.clamp((double)healthRatio, (double)0.0, (double)1.0)));
                }
            }
        }
        if (!this.level().isClientSide) {
            if (this.mouthAnimCooldown > 0) {
                --this.mouthAnimCooldown;
            } else {
                this.triggerAnim("mouthController", "mouth");
                this.playSound(ModSounds.MOGANOPTERUS_CALL.get(), 1.0f, 1.0f);
                this.mouthAnimCooldown = this.random.nextInt(601) + 600;
            }
        }
        if (this.level().isClientSide) {
            this.tailSwayPrev = this.tailSwayOffset;
            this.updateProceduralTailSway();
        }
    }

    private void updateProceduralTailSway() {
        float turnDegrees = this.getSignedTurnDelta();
        float deadzoneDeg = 0.6f;
        float turnInput = 0.0f;
        if (Math.abs(turnDegrees) >= deadzoneDeg) {
            turnInput = Mth.clamp((float)(turnDegrees / 15.0f), (float)-1.0f, (float)1.0f);
        }
        float target = turnInput;
        float alpha = 0.24f;
        this.tailSwayOffset += (target - this.tailSwayOffset) * alpha;
        if (Math.abs(this.tailSwayOffset) < 0.003f) {
            this.tailSwayOffset = 0.0f;
        }
        this.tailSwayVelocity = 0.0f;
        this.tailSwayOffset = Mth.clamp((float)this.tailSwayOffset, (float)-1.5f, (float)1.5f);
    }

    public float getTailSwayOffset() {
        return this.tailSwayOffset;
    }

    public float getTailSwayOffset(float partialTick) {
        return Mth.lerp((float)Mth.clamp((float)partialTick, (float)0.0f, (float)1.0f), (float)this.tailSwayPrev, (float)this.tailSwayOffset);
    }

    protected void defineSynchedData(SynchedEntityData.Builder pBuilder) {
        super.defineSynchedData(pBuilder);
        pBuilder.define(DATA_ID_TYPE_VARIANT, (Object)0);
        pBuilder.define(DATA_SYNCED_AGE, (Object)0);
    }

    public int getSyncedAge() {
        return (Integer)this.entityData.get(DATA_SYNCED_AGE);
    }

    public MoganopterusVariant getVariant() {
        return MoganopterusVariant.byId(this.getTypeVariant() & 0xFF);
    }

    public int getTypeVariant() {
        return (Integer)this.entityData.get(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(MoganopterusVariant variant) {
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public boolean canMate(Animal other) {
        if (!super.canMate(other)) {
            return false;
        }
        if (!(other instanceof MoganopterusEntity)) {
            return false;
        }
        MoganopterusEntity that = (MoganopterusEntity)other;
        return this.getVariant() != that.getVariant();
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData) {
        MoganopterusVariant variant = (MoganopterusVariant)((Object)Util.getRandom((Object[])MoganopterusVariant.values(), (RandomSource)this.random));
        this.setVariant(variant);
        return super.finalizeSpawn(pLevel, pDifficulty, pReason, pSpawnData);
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.entityData.set(DATA_ID_TYPE_VARIANT, (Object)pCompound.getInt("Variant"));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putInt("Variant", this.getTypeVariant());
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return ModSounds.MOGANOPTERUS_HURT.get();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return ModSounds.MOGANOPTERUS_DEATH.get();
    }
}

