/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.event;

import net.cmr.jurassicrevived.block.custom.FencePoleBlock;
import net.cmr.jurassicrevived.block.custom.FenceWireBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.event.level.BlockEvent;

public class FenceDiagonalUpdateHandler {
    public static void onNeighborNotify(BlockEvent.NeighborNotifyEvent e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        FenceDiagonalUpdateHandler.notifyDiagonalFences(level, e.getPos());
    }

    public static void onEntityPlace(BlockEvent.EntityPlaceEvent e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        FenceDiagonalUpdateHandler.notifyDiagonalFences(level, e.getPos());
    }

    public static void onBreak(BlockEvent.BreakEvent e) {
        LevelAccessor levelAccessor = e.getLevel();
        if (!(levelAccessor instanceof Level)) {
            return;
        }
        Level level = (Level)levelAccessor;
        FenceDiagonalUpdateHandler.notifyDiagonalFences(level, e.getPos());
    }

    private static void notifyDiagonalFences(Level level, BlockPos changedPos) {
        BlockPos[] diagonals;
        for (BlockPos p : diagonals = new BlockPos[]{changedPos.north().east(), changedPos.south().east(), changedPos.south().west(), changedPos.north().west()}) {
            BlockState updated;
            BlockState bs = level.getBlockState(p);
            if (bs.getBlock() instanceof FenceWireBlock) {
                updated = (BlockState)((BlockState)((BlockState)((BlockState)bs.setValue((Property)FenceWireBlock.NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.EAST)))).setValue((Property)FenceWireBlock.SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.EAST)))).setValue((Property)FenceWireBlock.SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.WEST)))).setValue((Property)FenceWireBlock.NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.WEST)));
                if (updated == bs) continue;
                level.setBlock(p, updated, 2);
                continue;
            }
            if (!(bs.getBlock() instanceof FencePoleBlock) || (updated = (BlockState)((BlockState)((BlockState)((BlockState)bs.setValue((Property)FencePoleBlock.NE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.EAST)))).setValue((Property)FencePoleBlock.SE, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.EAST)))).setValue((Property)FencePoleBlock.SW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.SOUTH, Direction.WEST)))).setValue((Property)FencePoleBlock.NW, (Comparable)Boolean.valueOf(FenceWireBlock.canConnectDiagonally((LevelAccessor)level, p, Direction.NORTH, Direction.WEST)))) == bs) continue;
            level.setBlock(p, updated, 2);
        }
    }
}

