/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.item.custom;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.DeferredSpawnEggItem;

public class CustomGenderedSpawnEggItem
extends DeferredSpawnEggItem {
    private static final String KEY_SELECTED_VARIANT = "SelectedVariant";
    private static final String KEY_VARIANT = "Variant";
    private static final int VARIANT_COUNT = 2;
    private final Supplier<? extends EntityType<? extends Mob>> spawnTypeSupplier;

    public CustomGenderedSpawnEggItem(Supplier<? extends EntityType<? extends Mob>> type, int backgroundColor, int highlightColor, Item.Properties properties) {
        super(type, backgroundColor, highlightColor, properties);
        this.spawnTypeSupplier = type;
    }

    private static int getSelectedVariant(ItemStack stack) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return 0;
        }
        CompoundTag tag = data.copyTag();
        if (!tag.contains(KEY_SELECTED_VARIANT)) {
            return 0;
        }
        return Math.floorMod(tag.getInt(KEY_SELECTED_VARIANT), 2);
    }

    private static void setSelectedVariant(ItemStack stack, int variant) {
        int v = Math.floorMod(variant, 2);
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, existing -> {
            CompoundTag tag = existing.copyTag();
            tag.putInt(KEY_SELECTED_VARIANT, v);
            return CustomData.of((CompoundTag)tag);
        });
    }

    private static void cycleVariant(ItemStack stack) {
        CustomGenderedSpawnEggItem.setSelectedVariant(stack, (CustomGenderedSpawnEggItem.getSelectedVariant(stack) + 1) % 2);
    }

    private static void ensureEntityDataHasVariant(ItemStack stack) {
        int variant = CustomGenderedSpawnEggItem.getSelectedVariant(stack);
        stack.update(DataComponents.ENTITY_DATA, (Object)CustomData.EMPTY, existing -> {
            CompoundTag tag = existing.copyTag();
            tag.putInt(KEY_VARIANT, variant);
            return CustomData.of((CompoundTag)tag);
        });
    }

    private static void clearEntityData(ItemStack stack) {
        stack.remove(DataComponents.ENTITY_DATA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isSecondaryUseActive()) {
            if (!level.isClientSide) {
                CustomGenderedSpawnEggItem.cycleVariant(stack);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 1.1f);
            }
            return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)level.isClientSide);
        }
        CustomGenderedSpawnEggItem.ensureEntityDataHasVariant(stack);
        try {
            InteractionResultHolder interactionResultHolder = super.use(level, player, hand);
            return interactionResultHolder;
        }
        finally {
            CustomGenderedSpawnEggItem.clearEntityData(stack);
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && player.isSecondaryUseActive()) {
            Level level = context.getLevel();
            if (!level.isClientSide) {
                CustomGenderedSpawnEggItem.cycleVariant(context.getItemInHand());
                level.playSound(null, context.getClickedPos(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 0.5f, 1.1f);
            }
            return InteractionResult.sidedSuccess((boolean)context.getLevel().isClientSide());
        }
        if (player == null || !player.isSecondaryUseActive()) {
            CustomGenderedSpawnEggItem.ensureEntityDataHasVariant(context.getItemInHand());
            InteractionResult result = super.useOn(context);
            CustomGenderedSpawnEggItem.clearEntityData(context.getItemInHand());
            return result;
        }
        return super.useOn(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity target, InteractionHand hand) {
        if (target instanceof Mob) {
            Mob mob = (Mob)target;
            EntityType<? extends Mob> eggType = this.spawnTypeSupplier.get();
            if (mob.getType() == eggType) {
                int parentVariant = this.readVariantFromEntity(mob);
                int previous = CustomGenderedSpawnEggItem.getSelectedVariant(stack);
                CustomGenderedSpawnEggItem.setSelectedVariant(stack, parentVariant);
                CustomGenderedSpawnEggItem.ensureEntityDataHasVariant(stack);
                try {
                    InteractionResult interactionResult = super.interactLivingEntity(stack, player, target, hand);
                    return interactionResult;
                }
                finally {
                    CustomGenderedSpawnEggItem.clearEntityData(stack);
                    CustomGenderedSpawnEggItem.setSelectedVariant(stack, previous);
                }
            }
        }
        return super.interactLivingEntity(stack, player, target, hand);
    }

    private int readVariantFromEntity(Mob mob) {
        CompoundTag nbt = new CompoundTag();
        mob.saveWithoutId(nbt);
        if (nbt.contains(KEY_VARIANT)) {
            return Math.floorMod(nbt.getInt(KEY_VARIANT), 2);
        }
        CompoundTag pd = mob.getPersistentData();
        if (pd != null && pd.contains(KEY_VARIANT)) {
            return Math.floorMod(pd.getInt(KEY_VARIANT), 2);
        }
        return 0;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext ctx, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, ctx, tooltip, flag);
        int v = CustomGenderedSpawnEggItem.getSelectedVariant(stack);
        String genderText = v == 0 ? "Male" : "Female";
        tooltip.add((Component)Component.translatable((String)"tooltip.jurassicrevived.gender", (Object[])new Object[]{genderText}));
        tooltip.add((Component)Component.translatable((String)"tooltip.jurassicrevived.gender.hint", (Object[])new Object[]{"Shift-Right-Click"}));
    }

    public Component getName(ItemStack stack) {
        Component base = super.getName(stack);
        boolean male = CustomGenderedSpawnEggItem.getSelectedVariant(stack) == 0;
        MutableComponent gender = Component.literal((String)(male ? "Male" : "Female")).withStyle(male ? ChatFormatting.AQUA : ChatFormatting.LIGHT_PURPLE);
        return base.copy().append((Component)Component.literal((String)" (")).append((Component)gender).append((Component)Component.literal((String)")"));
    }
}

