/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;

public class AddItemLootModifier
implements IGlobalLootModifier {
    private final LootItemCondition[] conditions;
    private final ItemStack stack;
    private final float chance;
    public static final MapCodec<AddItemLootModifier> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)LootItemCondition.DIRECT_CODEC.listOf().fieldOf("conditions").forGetter(m -> Arrays.asList(m.conditions)), (App)ItemStack.CODEC.fieldOf("item").forGetter(m -> m.stack), (App)Codec.FLOAT.fieldOf("chance").orElse((Object)Float.valueOf(1.0f)).forGetter(m -> Float.valueOf(m.chance))).apply((Applicative)inst, (conds, stack, chance) -> new AddItemLootModifier((LootItemCondition[])conds.toArray(LootItemCondition[]::new), (ItemStack)stack, chance.floatValue())));

    public AddItemLootModifier(LootItemCondition[] conditions, ItemStack stack, float chance) {
        this.conditions = conditions;
        this.stack = stack.copy();
        this.chance = chance;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }

    public ObjectArrayList<ItemStack> apply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        for (LootItemCondition cond : this.conditions) {
            if (cond.test((Object)context)) continue;
            return generatedLoot;
        }
        if (context.getRandom().nextFloat() < this.chance) {
            generatedLoot.add((Object)this.stack.copy());
        }
        return generatedLoot;
    }
}

