/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.cmr.jurassicrevived.recipe.DNAHybridizerRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public record DNAHybridizerRecipe(NonNullList<Ingredient> inputs, ItemStack output) implements Recipe<DNAHybridizerRecipeInput>
{
    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)ModRecipes.DNA_HYBRIDIZER_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> getType() {
        return (RecipeType)ModRecipes.DNA_HYBRIDIZER_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> getIngredients() {
        return this.inputs;
    }

    public boolean matches(@NotNull DNAHybridizerRecipeInput recipeInput, Level level) {
        if (level.isClientSide) {
            return false;
        }
        if (recipeInput.size() != 9) {
            return false;
        }
        if (this.inputs.isEmpty() || this.inputs.size() > 9) {
            return false;
        }
        boolean hasCatalyst = this.inputs.size() >= 9 && !((Ingredient)this.inputs.get(8)).isEmpty();
        ItemStack slot9 = recipeInput.getItem(8);
        if (hasCatalyst ? slot9.isEmpty() || !((Ingredient)this.inputs.get(8)).test(slot9) : !slot9.isEmpty()) {
            return false;
        }
        ArrayList<Ingredient> required = new ArrayList<Ingredient>();
        int max = Math.min(8, this.inputs.size());
        for (int i = 0; i < max; ++i) {
            Ingredient ing = (Ingredient)this.inputs.get(i);
            if (ing.isEmpty()) continue;
            required.add(ing);
        }
        if (required.isEmpty()) {
            return false;
        }
        boolean[] used = new boolean[9];
        used[8] = true;
        for (Ingredient need : required) {
            boolean matched = false;
            for (int i = 0; i < 8; ++i) {
                ItemStack stack;
                if (used[i] || (stack = recipeInput.getItem(i)).isEmpty() || !need.test(stack)) continue;
                used[i] = true;
                matched = true;
                break;
            }
            if (matched) continue;
            return false;
        }
        for (int i = 0; i < 8; ++i) {
            if (used[i] || recipeInput.getItem(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack assemble(@NotNull DNAHybridizerRecipeInput recipeInput, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public boolean canCraftInDimensions(int width, int height) {
        return true;
    }

    @NotNull
    public ItemStack getResultItem(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        return this.output.copy();
    }

    public static class Serializer
    implements RecipeSerializer<DNAHybridizerRecipe> {
        public static final MapCodec<DNAHybridizerRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Ingredient.CODEC.listOf().fieldOf("ingredients").flatXmap(list -> {
            if (list.isEmpty() || list.size() > 9) {
                return DataResult.error(() -> "DNAHybridizerRecipe requires 1-9 ingredients, got " + list.size());
            }
            NonNullList nnl = NonNullList.create();
            nnl.addAll((Collection)list);
            return DataResult.success((Object)nnl);
        }, nnl -> DataResult.success(List.copyOf(nnl))).forGetter(DNAHybridizerRecipe::inputs), (App)ItemStack.CODEC.fieldOf("result").forGetter(DNAHybridizerRecipe::output)).apply((Applicative)instance, DNAHybridizerRecipe::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DNAHybridizerRecipe> STREAM_CODEC = StreamCodec.of((buf, recipe) -> {
            ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).encode(buf, recipe.inputs());
            ItemStack.STREAM_CODEC.encode(buf, (Object)recipe.output());
        }, buf -> {
            NonNullList decodedInputs = (NonNullList)ByteBufCodecs.collection(NonNullList::createWithCapacity, (StreamCodec)Ingredient.CONTENTS_STREAM_CODEC).decode(buf);
            if (decodedInputs.isEmpty() || decodedInputs.size() > 9) {
                throw new IllegalArgumentException("DNAHybridizerRecipe requires 1-9 ingredients in stream, got " + decodedInputs.size());
            }
            ItemStack result = (ItemStack)ItemStack.STREAM_CODEC.decode(buf);
            return new DNAHybridizerRecipe((NonNullList<Ingredient>)decodedInputs, result);
        });

        @NotNull
        public MapCodec<DNAHybridizerRecipe> codec() {
            return CODEC;
        }

        @NotNull
        public StreamCodec<RegistryFriendlyByteBuf, DNAHybridizerRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

