/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.screen.custom;

import net.cmr.jurassicrevived.block.entity.custom.CrateBlockEntity;
import net.cmr.jurassicrevived.screen.ModMenuTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class CrateMenu
extends AbstractContainerMenu {
    public final CrateBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;

    public CrateMenu(int id, Inventory inv, FriendlyByteBuf buf) {
        this(id, inv, (CrateBlockEntity)inv.player.level().getBlockEntity(buf.readBlockPos()));
    }

    public CrateMenu(int id, Inventory inv, CrateBlockEntity be) {
        super(CrateMenu.resolveType(be), id);
        this.blockEntity = be;
        this.level = inv.player.level();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        int size = be.getSize();
        if (size == 9) {
            int startX = 8;
            int startY = 62;
            for (int c = 0; c < 9; ++c) {
                int idx = c;
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)be.itemHandler, idx, startX + c * 18, startY));
            }
        } else {
            int c;
            int startX = 8;
            int row1Y = 44;
            int row2Y = 62;
            for (c = 0; c < 9; ++c) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)be.itemHandler, c, startX + c * 18, row1Y));
            }
            for (c = 0; c < 9; ++c) {
                this.addSlot((Slot)new SlotItemHandler((IItemHandler)be.itemHandler, 9 + c, startX + c * 18, row2Y));
            }
        }
    }

    private static MenuType<?> resolveType(CrateBlockEntity be) {
        return be.getSize() == 9 ? (MenuType)ModMenuTypes.WOOD_CRATE_MENU.get() : (MenuType)ModMenuTypes.IRON_CRATE_MENU.get();
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot source = (Slot)this.slots.get(index);
        if (source == null || !source.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = source.getItem();
        ItemStack copy = sourceStack.copy();
        int teSlots = this.blockEntity.itemHandler.getSlots();
        int teFirst = 36;
        int teEnd = teFirst + teSlots;
        if (index < 36) {
            if (!this.moveItemStackTo(sourceStack, teFirst, teEnd, false)) {
                return ItemStack.EMPTY;
            }
        } else if (index >= teFirst && index < teEnd) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            return ItemStack.EMPTY;
        }
        if (sourceStack.isEmpty()) {
            source.set(ItemStack.EMPTY);
        } else {
            source.setChanged();
        }
        source.onTake(playerIn, sourceStack);
        return copy;
    }

    public boolean stillValid(Player player) {
        return CrateMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)this.blockEntity.getBlockState().getBlock());
    }

    private void addPlayerInventory(Inventory inv) {
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                this.addSlot(new Slot((Container)inv, c + r * 9 + 9, 8 + c * 18, 84 + r * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory inv) {
        for (int c = 0; c < 9; ++c) {
            this.addSlot(new Slot((Container)inv, c, 8 + c * 18, 142));
        }
    }
}

