/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.screen.custom.EmbryonicMachineMenu;
import net.cmr.jurassicrevived.screen.renderer.EnergyDisplayTooltipArea;
import net.cmr.jurassicrevived.util.MouseUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class EmbryonicMachineScreen
extends AbstractContainerScreen<EmbryonicMachineMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/embryonic_machine/embryonic_machine_gui.png");
    private static final ResourceLocation SYRINGE_BAR_REVERSED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/syringe_bar_reversed.png");
    private static final ResourceLocation WHITE_SYRINGE_BAR_REVERSED_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/white_syringe_bar_reversed.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    private static final ResourceLocation TEST_TUBE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/test_tube.png");
    private static final ResourceLocation SYRINGE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/syringe.png");
    private EnergyDisplayTooltipArea energyInfoArea;

    public EmbryonicMachineScreen(EmbryonicMachineMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignEnergyInfoArea();
    }

    private void renderEnergyAreaTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (EmbryonicMachineScreen.isMouseAboveArea(pMouseX, pMouseY, x, y, 160, 11, 8, 64) && Config.REQUIRE_POWER) {
            guiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void assignEnergyInfoArea() {
        this.energyInfoArea = new EnergyDisplayTooltipArea((this.width - this.imageWidth) / 2 + 160, (this.height - this.imageHeight) / 2 + 11, ((EmbryonicMachineMenu)this.menu).blockEntity.getEnergyStorage(null));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (Config.REQUIRE_POWER) {
            this.renderEnergyAreaTooltip(guiGraphics, pMouseX, pMouseY, x, y);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 166);
        guiGraphics.blit(SYRINGE_BAR_REVERSED_TEXTURE, x + 76, y + 35, 0.0f, 0.0f, 24, 16, 24, 16);
        guiGraphics.blit(SYRINGE_TEXTURE, x + 39, y + 35, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.blit(TEST_TUBE_TEXTURE, x + 57, y + 35, 0.0f, 0.0f, 16, 16, 16, 16);
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, x + 159, y + 10, 0.0f, 0.0f, 10, 66, 10, 66);
        }
    }

    private void RenderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((EmbryonicMachineMenu)this.menu).isCrafting()) {
            guiGraphics.blit(WHITE_SYRINGE_BAR_REVERSED_TEXTURE, x + 76, y + 35, 0.0f, 0.0f, ((EmbryonicMachineMenu)this.menu).getScaledArrowProgress(), 16, 24, 16);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.RenderProgressArrow(guiGraphics, x, y);
        if (Config.REQUIRE_POWER) {
            this.energyInfoArea.render(guiGraphics);
        }
    }

    public static boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, width, height);
    }
}

