/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.screen.custom.FossilCleanerMenu;
import net.cmr.jurassicrevived.screen.renderer.EnergyDisplayTooltipArea;
import net.cmr.jurassicrevived.screen.renderer.FluidTankRenderer;
import net.cmr.jurassicrevived.util.MouseUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.neoforge.fluids.FluidStack;

public class FossilCleanerScreen
extends AbstractContainerScreen<FossilCleanerMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/fossil_cleaner/fossil_cleaner_gui.png");
    private static final ResourceLocation BUBBLES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/bubbles.png");
    private static final ResourceLocation WHITE_BUBBLES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/white_bubbles.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    private static final ResourceLocation SKULL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/skull.png");
    private FluidTankRenderer fluidRenderer;
    private EnergyDisplayTooltipArea energyInfoArea;

    public FossilCleanerScreen(FossilCleanerMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignFluidRenderer();
        this.assignEnergyInfoArea();
    }

    private void renderEnergyAreaTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (FossilCleanerScreen.isMouseAboveArea(pMouseX, pMouseY, x, y, 160, 11, 8, 64) && Config.REQUIRE_POWER) {
            guiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void assignEnergyInfoArea() {
        this.energyInfoArea = new EnergyDisplayTooltipArea((this.width - this.imageWidth) / 2 + 160, (this.height - this.imageHeight) / 2 + 11, ((FossilCleanerMenu)this.menu).blockEntity.getEnergyStorage(null));
    }

    private void assignFluidRenderer() {
        this.fluidRenderer = new FluidTankRenderer(16000L, true, 16, 50);
    }

    private void renderFluidTooltipArea(GuiGraphics guiGraphics, int MouseX, int MouseY, int x, int y, FluidStack stack, int offsetX, int offsetY, FluidTankRenderer renderer) {
        if (FossilCleanerScreen.isMouseAboveArea(MouseX, MouseY, x, y, offsetX, offsetY, renderer)) {
            guiGraphics.renderTooltip(this.font, renderer.getTooltip(stack, (TooltipFlag)TooltipFlag.Default.NORMAL), Optional.empty(), MouseX - x, MouseY - y);
        }
    }

    protected void renderLabels(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderFluidTooltipArea(guiGraphics, pMouseX, pMouseY, x, y, ((FossilCleanerMenu)this.menu).blockEntity.getFluid(), 7, 8, this.fluidRenderer);
        if (Config.REQUIRE_POWER) {
            this.renderEnergyAreaTooltip(guiGraphics, pMouseX, pMouseY, x, y);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 166);
        guiGraphics.blit(BUBBLES_TEXTURE, x + 73, y + 37, 0.0f, 0.0f, 29, 12, 29, 12);
        guiGraphics.blit(SKULL_TEXTURE, x + 57, y + 35, 0.0f, 0.0f, 16, 16, 16, 16);
        this.RenderProgressArrow(guiGraphics, x, y);
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, x + 159, y + 10, 0.0f, 0.0f, 10, 66, 10, 66);
        }
    }

    private void RenderProgressArrow(GuiGraphics guiGraphics, int x, int y) {
        if (((FossilCleanerMenu)this.menu).isCrafting()) {
            guiGraphics.blit(WHITE_BUBBLES_TEXTURE, x + 73, y + 37, 0.0f, 0.0f, ((FossilCleanerMenu)this.menu).getScaledArrowProgress(), 12, 29, 12);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (MouseUtil.isMouseOver(mouseX, mouseY, x + 7, y + 8, 16, 50)) {
            FossilCleanerScreen.renderHoverHighlight(guiGraphics, x + 7, y + 8, 16, 50);
        }
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.fluidRenderer.render(guiGraphics, x + 7, y + 8, ((FossilCleanerMenu)this.menu).blockEntity.getFluid());
        if (Config.REQUIRE_POWER) {
            this.energyInfoArea.render(guiGraphics);
        }
    }

    private static void renderHoverHighlight(GuiGraphics g, int x, int y, int w, int h) {
        g.pose().pushPose();
        g.pose().translate(0.0f, 0.0f, 200.0f);
        g.fillGradient(x, y, x + w, y + h, -2130706433, -2130706433);
        g.pose().popPose();
    }

    public static boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, FluidTankRenderer renderer) {
        return MouseUtil.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, renderer.getWidth(), renderer.getHeight());
    }

    public static boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, width, height);
    }
}

