/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.screen.custom;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.screen.custom.FossilGrinderMenu;
import net.cmr.jurassicrevived.screen.renderer.EnergyDisplayTooltipArea;
import net.cmr.jurassicrevived.util.MouseUtil;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class FossilGrinderScreen
extends AbstractContainerScreen<FossilGrinderMenu> {
    private static final ResourceLocation GUI_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/fossil_grinder/fossil_grinder_gui.png");
    private static final ResourceLocation CUTTING_BLADES_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/cutting_blades.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    private static final ResourceLocation SKULL_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/skull.png");
    private EnergyDisplayTooltipArea energyInfoArea;

    public FossilGrinderScreen(FossilGrinderMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, title);
    }

    protected void init() {
        super.init();
        this.inventoryLabelY = 10000;
        this.titleLabelY = 10000;
        this.assignEnergyInfoArea();
    }

    private void renderEnergyAreaTooltip(GuiGraphics guiGraphics, int pMouseX, int pMouseY, int x, int y) {
        if (FossilGrinderScreen.isMouseAboveArea(pMouseX, pMouseY, x, y, 160, 11, 8, 64) && Config.REQUIRE_POWER) {
            guiGraphics.renderTooltip(this.font, this.energyInfoArea.getTooltips(), Optional.empty(), pMouseX - x, pMouseY - y);
        }
    }

    private void assignEnergyInfoArea() {
        this.energyInfoArea = new EnergyDisplayTooltipArea((this.width - this.imageWidth) / 2 + 160, (this.height - this.imageHeight) / 2 + 11, ((FossilGrinderMenu)this.menu).blockEntity.getEnergyStorage(null));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (Config.REQUIRE_POWER) {
            this.renderEnergyAreaTooltip(guiGraphics, pMouseX, pMouseY, x, y);
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float v, int i, int i1) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)GUI_TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(GUI_TEXTURE, x, y, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 176, 166);
        guiGraphics.blit(SKULL_TEXTURE, x + 57, y + 35, 0.0f, 0.0f, 16, 16, 16, 16);
        float scale = 1.25f;
        int texSize = 16;
        float baseAngle = (float)(System.currentTimeMillis() % 700L) / 700.0f * ((float)Math.PI * 2);
        BiConsumer<int[], Float> drawBlade = (center, ang) -> {
            guiGraphics.pose().pushPose();
            guiGraphics.pose().translate((float)center[0], (float)center[1], 0.0f);
            guiGraphics.pose().scale(1.25f, 1.25f, 1.0f);
            if (ang != null) {
                guiGraphics.pose().mulPose(Axis.ZP.rotation(-ang.floatValue()));
            }
            guiGraphics.pose().translate(-8.0f, -8.0f, 0.0f);
            guiGraphics.blit(CUTTING_BLADES_TEXTURE, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
            guiGraphics.pose().popPose();
        };
        int cx1 = x + 89;
        int cy1 = y + 34;
        int cx2 = x + 89;
        int cy2 = y + 52;
        if (((FossilGrinderMenu)this.menu).isCrafting()) {
            drawBlade.accept(new int[]{cx1, cy1}, Float.valueOf(baseAngle));
            drawBlade.accept(new int[]{cx2, cy2}, Float.valueOf(-baseAngle));
        } else {
            drawBlade.accept(new int[]{cx1, cy1}, null);
            drawBlade.accept(new int[]{cx2, cy2}, null);
        }
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, x + 159, y + 10, 0.0f, 0.0f, 10, 66, 10, 66);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        if (Config.REQUIRE_POWER) {
            this.energyInfoArea.render(guiGraphics);
        }
    }

    public static boolean isMouseAboveArea(int pMouseX, int pMouseY, int x, int y, int offsetX, int offsetY, int width, int height) {
        return MouseUtil.isMouseOver(pMouseX, pMouseY, x + offsetX, y + offsetY, width, height);
    }
}

