/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.screen.custom;

import net.cmr.jurassicrevived.block.entity.custom.IncubatorBlockEntity;
import net.cmr.jurassicrevived.screen.ModMenuTypes;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

public class IncubatorMenu
extends AbstractContainerMenu {
    public final IncubatorBlockEntity blockEntity;
    public final Level level;
    public final ContainerData data;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 3;

    public IncubatorMenu(int containerId, Inventory inventory, FriendlyByteBuf data) {
        this(containerId, inventory, inventory.player.level().getBlockEntity(data.readBlockPos()), (ContainerData)new SimpleContainerData(6));
    }

    public IncubatorMenu(int containerId, Inventory inventory, BlockEntity entity, ContainerData data) {
        super((MenuType)ModMenuTypes.INCUBATOR_MENU.get(), containerId);
        this.blockEntity = (IncubatorBlockEntity)entity;
        this.level = inventory.player.level();
        this.data = data;
        this.addPlayerInventory(inventory);
        this.addPlayerHotbar(inventory);
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 0, 50, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.EGGS);
            }

            public boolean mayPickup(Player playerIn) {
                return true;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 1, 80, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.EGGS);
            }

            public boolean mayPickup(Player playerIn) {
                return true;
            }
        });
        this.addSlot((Slot)new SlotItemHandler(this, (IItemHandler)this.blockEntity.itemHandler, 2, 110, 35){

            public boolean mayPlace(ItemStack stack) {
                return stack.is(ModTags.Items.EGGS);
            }

            public boolean mayPickup(Player playerIn) {
                return true;
            }
        });
        this.addDataSlots(data);
    }

    public boolean isCrafting(int slotIndex) {
        if (slotIndex < 0 || slotIndex > 2) {
            return false;
        }
        return this.data.get(slotIndex * 2) > 0;
    }

    public float getScaledArrowProgress(int slotIndex) {
        if (slotIndex < 0 || slotIndex > 2) {
            return 0.0f;
        }
        int p = this.data.get(slotIndex * 2);
        int m = this.data.get(slotIndex * 2 + 1);
        if (m == 0) {
            return 0.0f;
        }
        return Math.max(0.0f, Math.min(1.0f, (float)p / (float)m));
    }

    public ItemStack quickMoveStack(Player playerIn, int pIndex) {
        Slot sourceSlot = (Slot)this.slots.get(pIndex);
        if (sourceSlot == null || !sourceSlot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack sourceStack = sourceSlot.getItem();
        ItemStack copyOfSourceStack = sourceStack.copy();
        if (pIndex < 36) {
            int teInputStart = 36;
            int teInputEndExclusive = 39;
            if (!this.moveItemStackTo(sourceStack, teInputStart, teInputEndExclusive, false)) {
                return ItemStack.EMPTY;
            }
        } else if (pIndex < 39) {
            if (!this.moveItemStackTo(sourceStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
        } else {
            System.out.println("Invalid slotIndex:" + pIndex);
            return ItemStack.EMPTY;
        }
        if (sourceStack.getCount() == 0) {
            sourceSlot.set(ItemStack.EMPTY);
        } else {
            sourceSlot.setChanged();
        }
        sourceSlot.onTake(playerIn, sourceStack);
        return copyOfSourceStack;
    }

    public boolean stillValid(Player player) {
        return IncubatorMenu.stillValid((ContainerLevelAccess)ContainerLevelAccess.create((Level)this.level, (BlockPos)this.blockEntity.getBlockPos()), (Player)player, (Block)this.blockEntity.getBlockState().getBlock());
    }

    public void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.addSlot(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 84 + i * 18));
            }
        }
    }

    public void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }
}

