/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.sound;

import net.cmr.jurassicrevived.sound.ModSounds;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MachineHumLoopSound
extends AbstractTickableSoundInstance {
    private final Level level;
    private final BlockPos pos;

    public MachineHumLoopSound(Level level, BlockPos pos) {
        super(ModSounds.MACHINE_HUM_SOUND.get(), SoundSource.BLOCKS, SoundInstance.createUnseededRandom());
        this.level = level;
        this.pos = pos.immutable();
        this.x = (double)pos.getX() + 0.5;
        this.y = (double)pos.getY() + 0.5;
        this.z = (double)pos.getZ() + 0.5;
        this.volume = 1.0f;
        this.pitch = 1.0f;
        this.looping = true;
        this.delay = 0;
        this.relative = false;
    }

    public void tick() {
        if (this.isStopped()) {
            return;
        }
        BlockState state = this.level.getBlockState(this.pos);
        if (state.isAir() || !state.hasProperty((Property)BlockStateProperties.LIT) || !((Boolean)state.getValue((Property)BlockStateProperties.LIT)).booleanValue()) {
            this.stop();
        }
    }

    public void stopPlaying() {
        this.stop();
    }
}

