/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.sound;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.cmr.jurassicrevived.block.custom.DNAAnalyzerBlock;
import net.cmr.jurassicrevived.block.custom.DNAExtractorBlock;
import net.cmr.jurassicrevived.block.custom.DNAHybridizerBlock;
import net.cmr.jurassicrevived.block.custom.EmbryoCalcificationMachineBlock;
import net.cmr.jurassicrevived.block.custom.EmbryonicMachineBlock;
import net.cmr.jurassicrevived.block.custom.FossilCleanerBlock;
import net.cmr.jurassicrevived.block.custom.FossilGrinderBlock;
import net.cmr.jurassicrevived.block.custom.GeneratorBlock;
import net.cmr.jurassicrevived.block.custom.IncubatorBlock;
import net.cmr.jurassicrevived.sound.MachineHumLoopSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="jurassicrevived", value={Dist.CLIENT})
public final class MachineHumSoundHandler {
    private static final Map<BlockPos, MachineHumLoopSound> ACTIVE_SOUNDS = new HashMap<BlockPos, MachineHumLoopSound>();

    private MachineHumSoundHandler() {
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.isPaused()) {
            return;
        }
        ClientLevel level = mc.level;
        if (level == null) {
            MachineHumSoundHandler.stopAllSounds();
            return;
        }
        Iterator<Map.Entry<BlockPos, MachineHumLoopSound>> it = ACTIVE_SOUNDS.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<BlockPos, MachineHumLoopSound> entry = it.next();
            BlockPos pos = entry.getKey();
            MachineHumLoopSound sound = entry.getValue();
            BlockState state = level.getBlockState(pos);
            if (!MachineHumSoundHandler.shouldStopHum(state) && !sound.isStopped()) continue;
            sound.stopPlaying();
            it.remove();
        }
        if (mc.player != null) {
            int radius = 16;
            BlockPos center = mc.player.blockPosition();
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)center.offset(-radius, -radius, -radius), (BlockPos)center.offset(radius, radius, radius))) {
                BlockState state;
                BlockPos immutablePos = pos.immutable();
                if (ACTIVE_SOUNDS.containsKey(immutablePos) || !MachineHumSoundHandler.shouldStartHum(state = level.getBlockState(immutablePos))) continue;
                MachineHumLoopSound sound = new MachineHumLoopSound((Level)level, immutablePos);
                ACTIVE_SOUNDS.put(immutablePos, sound);
                mc.getSoundManager().play((SoundInstance)sound);
            }
        }
    }

    private static boolean shouldStartHum(BlockState state) {
        Block block = state.getBlock();
        if (!(block instanceof DNAAnalyzerBlock || block instanceof DNAExtractorBlock || block instanceof DNAHybridizerBlock || block instanceof EmbryoCalcificationMachineBlock || block instanceof EmbryonicMachineBlock || block instanceof FossilCleanerBlock || block instanceof FossilGrinderBlock || block instanceof GeneratorBlock || block instanceof IncubatorBlock)) {
            return false;
        }
        if (state.hasProperty((Property)BlockStateProperties.LIT)) {
            return (Boolean)state.getValue((Property)BlockStateProperties.LIT);
        }
        return false;
    }

    private static boolean shouldStopHum(BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.hasProperty((Property)BlockStateProperties.LIT)) {
            return (Boolean)state.getValue((Property)BlockStateProperties.LIT) == false;
        }
        return true;
    }

    private static void stopAllSounds() {
        for (MachineHumLoopSound sound : ACTIVE_SOUNDS.values()) {
            sound.stopPlaying();
        }
        ACTIVE_SOUNDS.clear();
    }
}

