/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.util;

import net.cmr.jurassicrevived.block.custom.FencePoleBlock;
import net.cmr.jurassicrevived.block.custom.FenceWireBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public final class FenceClimbClientHandler {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(FenceClimbClientHandler::onPlayerTickClient);
    }

    private static void onPlayerTickClient(PlayerTickEvent.Post e) {
        Player player = e.getEntity();
        Level level = player.level();
        if (!level.isClientSide || !player.isAlive()) {
            return;
        }
        AABB bb = player.getBoundingBox().inflate(0.05, 0.05, 0.05);
        int minX = Mth.floor((double)bb.minX);
        int maxX = Mth.floor((double)bb.maxX);
        int minY = Mth.floor((double)bb.minY);
        int maxY = Mth.floor((double)Math.min(bb.minY + 1.0, bb.maxY));
        int minZ = Mth.floor((double)bb.minZ);
        int maxZ = Mth.floor((double)bb.maxZ);
        boolean touching = false;
        block0: for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    VoxelShape shape;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.getBlockState(pos);
                    boolean isWire = state.getBlock() instanceof FenceWireBlock;
                    boolean isPole = state.getBlock() instanceof FencePoleBlock;
                    if (!isWire && !isPole || (shape = state.getCollisionShape((BlockGetter)level, pos, CollisionContext.of((Entity)player))).isEmpty()) continue;
                    if (isPole) {
                        AABB postAabbWorld = new AABB((double)pos.getX() + 0.375, (double)pos.getY() + 0.0, (double)pos.getZ() + 0.375, (double)pos.getX() + 0.625, (double)pos.getY() + 1.0, (double)pos.getZ() + 0.625);
                        for (AABB aabb : shape.toAabbs()) {
                            AABB moved = aabb.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                            if (FenceClimbClientHandler.approximatelySame(moved, postAabbWorld) || !bb.intersects(moved) || !FenceClimbClientHandler.notStandingOnTop(bb, moved)) continue;
                            touching = true;
                            break block0;
                        }
                        continue;
                    }
                    for (AABB aabb : shape.toAabbs()) {
                        AABB moved = aabb.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                        if (!bb.intersects(moved) || !FenceClimbClientHandler.notStandingOnTop(bb, moved)) continue;
                        touching = true;
                        break block0;
                    }
                }
            }
        }
        if (!touching) {
            return;
        }
        Vec3 v = player.getDeltaMovement();
        boolean sneaking = player.isShiftKeyDown();
        double maxHoriz = 0.15;
        double vx = Mth.clamp((double)v.x, (double)(-maxHoriz), (double)maxHoriz);
        double vz = Mth.clamp((double)v.z, (double)(-maxHoriz), (double)maxHoriz);
        boolean forward = Minecraft.getInstance().options.keyUp.isDown();
        double vy = v.y;
        vy = sneaking ? 0.0 : (forward ? 0.2 : Math.max(vy, -0.15));
        player.fallDistance = 0.0f;
        player.setDeltaMovement(vx, vy, vz);
        player.hasImpulse = true;
    }

    private static boolean approximatelySame(AABB a, AABB b) {
        double eps = 1.0E-6;
        return Math.abs(a.minX - b.minX) < eps && Math.abs(a.minY - b.minY) < eps && Math.abs(a.minZ - b.minZ) < eps && Math.abs(a.maxX - b.maxX) < eps && Math.abs(a.maxY - b.maxY) < eps && Math.abs(a.maxZ - b.maxZ) < eps;
    }

    private static boolean notStandingOnTop(AABB player, AABB block) {
        double eps = 0.05;
        return !(player.minY >= block.maxY - eps) || !(player.minY <= block.maxY + eps);
    }
}

