/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.util;

import net.cmr.jurassicrevived.block.custom.FencePoleBlock;
import net.cmr.jurassicrevived.block.custom.FenceWireBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

public final class FenceClimbHandler {
    public static void register() {
        NeoForge.EVENT_BUS.addListener(FenceClimbHandler::onServerTickEnd);
    }

    private static void onServerTickEnd(ServerTickEvent.Post e) {
        MinecraftServer server = e.getServer();
        for (ServerLevel level : server.getAllLevels()) {
            for (ServerPlayer player : level.players()) {
                if (!player.isAlive()) continue;
                boolean touching = false;
                AABB bb = player.getBoundingBox().inflate(0.05, 0.05, 0.05);
                int minX = Mth.floor((double)bb.minX);
                int maxX = Mth.floor((double)bb.maxX);
                int minY = Mth.floor((double)bb.minY);
                int maxY = Mth.floor((double)Math.min(bb.minY + 1.0, bb.maxY));
                int minZ = Mth.floor((double)bb.minZ);
                int maxZ = Mth.floor((double)bb.maxZ);
                block2: for (int x = minX; x <= maxX; ++x) {
                    for (int y = minY; y <= maxY; ++y) {
                        for (int z = minZ; z <= maxZ; ++z) {
                            VoxelShape shape;
                            BlockPos pos = new BlockPos(x, y, z);
                            BlockState state = level.getBlockState(pos);
                            boolean isWire = state.getBlock() instanceof FenceWireBlock;
                            boolean isPole = state.getBlock() instanceof FencePoleBlock;
                            if (!isWire && !isPole || (shape = state.getCollisionShape((BlockGetter)level, pos, CollisionContext.of((Entity)player))).isEmpty()) continue;
                            if (isPole) {
                                AABB postAabb = new AABB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625).move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                                for (AABB aabb : shape.toAabbs()) {
                                    AABB moved = aabb.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                                    if (FenceClimbHandler.approximatelySame(moved, postAabb) || !bb.intersects(moved) || !FenceClimbHandler.notStandingOnTop(bb, moved)) continue;
                                    touching = true;
                                    break block2;
                                }
                                continue;
                            }
                            for (AABB aabb : shape.toAabbs()) {
                                AABB moved = aabb.move((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                                if (!bb.intersects(moved) || !FenceClimbHandler.notStandingOnTop(bb, moved)) continue;
                                touching = true;
                                break block2;
                            }
                        }
                    }
                }
                if (!touching) continue;
                Vec3 v = player.getDeltaMovement();
                boolean sneaking = player.isShiftKeyDown();
                double maxHoriz = 0.15;
                double vx = Mth.clamp((double)v.x, (double)(-maxHoriz), (double)maxHoriz);
                double vz = Mth.clamp((double)v.z, (double)(-maxHoriz), (double)maxHoriz);
                double vy = v.y;
                if (sneaking) {
                    vy = Math.max(vy, 0.0);
                } else {
                    vy = Math.max(vy, -0.15);
                    vy = Math.max(vy, 0.01);
                }
                player.setOnGround(false);
                player.fallDistance = 0.0f;
                player.setDeltaMovement(vx, vy, vz);
                player.hasImpulse = true;
            }
        }
    }

    private static boolean approximatelySame(AABB a, AABB b) {
        double eps = 1.0E-6;
        return Math.abs(a.minX - b.minX) < eps && Math.abs(a.minY - b.minY) < eps && Math.abs(a.minZ - b.minZ) < eps && Math.abs(a.maxX - b.maxX) < eps && Math.abs(a.maxY - b.maxY) < eps && Math.abs(a.maxZ - b.maxZ) < eps;
    }

    private static boolean notStandingOnTop(AABB player, AABB block) {
        double eps = 0.05;
        return !(player.minY >= block.maxY - eps) || !(player.minY <= block.maxY + eps);
    }
}

