/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Supplier;
import net.cmr.jurassicrevived.Config;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.neoforge.common.world.BiomeModifier;
import net.neoforged.neoforge.common.world.BiomeModifiers;
import net.neoforged.neoforge.common.world.ModifiableBiomeInfo;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import org.jetbrains.annotations.NotNull;

public final class ConditionalAddSpawns
implements BiomeModifier {
    public static final MapCodec<ConditionalAddSpawns> RECORD_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Biome.LIST_CODEC.fieldOf("biomes").forGetter(m -> m.delegate.biomes()), (App)MobSpawnSettings.SpawnerData.CODEC.listOf().fieldOf("spawners").forGetter(m -> m.delegate.spawners())).apply((Applicative)instance, ConditionalAddSpawns::new));
    public static final DeferredRegister<MapCodec<? extends BiomeModifier>> CODECS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"jurassicrevived");
    public static final Supplier<MapCodec<ConditionalAddSpawns>> SERIALIZER = CODECS.register("conditional_add_spawns", () -> RECORD_CODEC);
    private final BiomeModifiers.AddSpawnsBiomeModifier delegate;

    public ConditionalAddSpawns(HolderSet<Biome> biomes, List<MobSpawnSettings.SpawnerData> spawners) {
        this.delegate = new BiomeModifiers.AddSpawnsBiomeModifier(biomes, spawners);
    }

    public void modify(@NotNull Holder<Biome> biome, @NotNull BiomeModifier.Phase phase, @NotNull ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (Config.NATURAL_DINOSAUR_SPAWNING) {
            this.delegate.modify(biome, phase, builder);
        }
    }

    @NotNull
    public MapCodec<? extends BiomeModifier> codec() {
        return SERIALIZER.get();
    }
}

