/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.worldgen;

import java.util.List;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class ModConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_GYPSUM_STONE_KEY = ModConfiguredFeatures.registerKey("gypsum_stone");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_STONE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("stone_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_DEEPSLATE_FOSSIL_KEY = ModConfiguredFeatures.registerKey("deepslate_fossil");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_AMBER_ORE_KEY = ModConfiguredFeatures.registerKey("amber_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_DEEPSLATE_ICE_SHARD_ORE_KEY = ModConfiguredFeatures.registerKey("deepslate_ice_shard_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> OVERWORLD_hq_ORE_KEY = ModConfiguredFeatures.registerKey("hq_ore");

    public static void bootstrap(BootstrapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.STONE_ORE_REPLACEABLES);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.DEEPSLATE_ORE_REPLACEABLES);
        TagMatchTest oceanReplaceables = new TagMatchTest(ModTags.Blocks.AQUATIC_PLACEMENT_REPLACEABLES);
        List<OreConfiguration.TargetBlockState> overworldGypsumStoneOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.GYPSUM_STONE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldStoneFossilOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.STONE_FOSSIL.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldDeepslateFossilOres = List.of(OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_FOSSIL.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldAmberOres = List.of(OreConfiguration.target((RuleTest)stoneReplaceables, (BlockState)((Block)ModBlocks.AMBER_ORE.get()).defaultBlockState()));
        List<OreConfiguration.TargetBlockState> overworldDeepslateIceShardOres = List.of(OreConfiguration.target((RuleTest)deepslateReplaceables, (BlockState)((Block)ModBlocks.DEEPSLATE_ICE_SHARD_ORE.get()).defaultBlockState()));
        ModConfiguredFeatures.register(context, OVERWORLD_GYPSUM_STONE_KEY, Feature.ORE, new OreConfiguration(overworldGypsumStoneOres, 18));
        ModConfiguredFeatures.register(context, OVERWORLD_STONE_FOSSIL_KEY, Feature.ORE, new OreConfiguration(overworldStoneFossilOres, 8));
        ModConfiguredFeatures.register(context, OVERWORLD_DEEPSLATE_FOSSIL_KEY, Feature.ORE, new OreConfiguration(overworldDeepslateFossilOres, 8));
        ModConfiguredFeatures.register(context, OVERWORLD_AMBER_ORE_KEY, Feature.ORE, new OreConfiguration(overworldAmberOres, 3));
        ModConfiguredFeatures.register(context, OVERWORLD_DEEPSLATE_ICE_SHARD_ORE_KEY, Feature.ORE, new OreConfiguration(overworldDeepslateIceShardOres, 3));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.CONFIGURED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstrapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.register(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

