/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.worldgen;

import java.util.List;
import net.cmr.jurassicrevived.worldgen.ModConfiguredFeatures;
import net.cmr.jurassicrevived.worldgen.ModOrePlacements;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;

public class ModPlacedFeatures {
    public static final ResourceKey<PlacedFeature> GYPSUM_STONE_PLACED_KEY = ModPlacedFeatures.registerKey("gypsum_stone_placed");
    public static final ResourceKey<PlacedFeature> STONE_FOSSIL_PLACED_KEY = ModPlacedFeatures.registerKey("stone_fossil_placed");
    public static final ResourceKey<PlacedFeature> DEEPSLATE_FOSSIL_PLACED_KEY = ModPlacedFeatures.registerKey("deepslate_fossil_placed");
    public static final ResourceKey<PlacedFeature> AMBER_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("amber_ore_placed");
    public static final ResourceKey<PlacedFeature> DEEPSLATE_ICE_SHARD_ORE_PLACED_KEY = ModPlacedFeatures.registerKey("deepslate_ice_shard_ore_placed");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        ModPlacedFeatures.register(context, GYPSUM_STONE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_GYPSUM_STONE_KEY), ModOrePlacements.commonOrePlacement(20, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)32), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        ModPlacedFeatures.register(context, STONE_FOSSIL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_STONE_FOSSIL_KEY), ModOrePlacements.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)64))));
        ModPlacedFeatures.register(context, DEEPSLATE_FOSSIL_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_DEEPSLATE_FOSSIL_KEY), ModOrePlacements.commonOrePlacement(15, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)0))));
        ModPlacedFeatures.register(context, AMBER_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_AMBER_ORE_KEY), ModOrePlacements.commonOrePlacement(4, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)0), (VerticalAnchor)VerticalAnchor.absolute((int)32))));
        ModPlacedFeatures.register(context, DEEPSLATE_ICE_SHARD_ORE_PLACED_KEY, configuredFeatures.getOrThrow(ModConfiguredFeatures.OVERWORLD_DEEPSLATE_ICE_SHARD_ORE_KEY), ModOrePlacements.commonOrePlacement(6, (PlacementModifier)HeightRangePlacement.uniform((VerticalAnchor)VerticalAnchor.absolute((int)-32), (VerticalAnchor)VerticalAnchor.absolute((int)0))));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

