/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived;

import com.mojang.logging.LogUtils;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.block.entity.custom.ModBlockEntities;
import net.cmr.jurassicrevived.datagen.custom.ConfigCondition;
import net.cmr.jurassicrevived.entity.ModEntities;
import net.cmr.jurassicrevived.event.FenceDiagonalUpdateHandler;
import net.cmr.jurassicrevived.item.ModCreativeModeTabs;
import net.cmr.jurassicrevived.item.ModItems;
import net.cmr.jurassicrevived.loot.ModLootModifiers;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.ModMenuTypes;
import net.cmr.jurassicrevived.util.FenceClimbHandler;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import org.slf4j.Logger;

@Mod(value="jurassicrevived")
public class JRMod {
    public static final String MOD_ID = "jurassicrevived";
    public static final Logger LOGGER = LogUtils.getLogger();

    public JRMod(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        ModItems.register(modEventBus);
        ModCreativeModeTabs.register(modEventBus);
        ModBlocks.register(modEventBus);
        ModEntities.register(modEventBus);
        ModBlockEntities.register(modEventBus);
        ModMenuTypes.register(modEventBus);
        ModRecipes.register(modEventBus);
        ModLootModifiers.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
        FenceClimbHandler.register();
        modEventBus.addListener(this::addCreative);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        NeoForge.EVENT_BUS.addListener(FenceDiagonalUpdateHandler::onNeighborNotify);
        NeoForge.EVENT_BUS.addListener(FenceDiagonalUpdateHandler::onEntityPlace);
        NeoForge.EVENT_BUS.addListener(FenceDiagonalUpdateHandler::onBreak);
        ConfigCondition.register(modEventBus);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.ROYAL_FERN.getId(), ModBlocks.POTTED_ROYAL_FERN);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.HORSETAIL_FERN.getId(), ModBlocks.POTTED_HORSETAIL_FERN);
            ((FlowerPotBlock)Blocks.FLOWER_POT).addPlant(ModBlocks.WESTERN_SWORD_FERN.getId(), ModBlocks.POTTED_WESTERN_SWORD_FERN);
        });
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("HELLO from server starting");
    }
}

