/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block;

import java.util.function.Supplier;
import net.cmr.jurassicrevived.block.custom.DNAExtractorBlock;
import net.cmr.jurassicrevived.block.custom.DNAHybridizerBlock;
import net.cmr.jurassicrevived.block.custom.DecoBlock;
import net.cmr.jurassicrevived.block.custom.EggBlock;
import net.cmr.jurassicrevived.block.custom.EmbryoCalcificationMachineBlock;
import net.cmr.jurassicrevived.block.custom.EmbryonicMachineBlock;
import net.cmr.jurassicrevived.block.custom.FencePoleBlock;
import net.cmr.jurassicrevived.block.custom.FenceWireBlock;
import net.cmr.jurassicrevived.block.custom.FossilCleanerBlock;
import net.cmr.jurassicrevived.block.custom.FossilGrinderBlock;
import net.cmr.jurassicrevived.block.custom.GeneratorBlock;
import net.cmr.jurassicrevived.block.custom.IncubatorBlock;
import net.cmr.jurassicrevived.block.custom.PipeBlock;
import net.cmr.jurassicrevived.entity.ModEntities;
import net.cmr.jurassicrevived.item.ModItems;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"jurassicrevived");
    public static final DeferredBlock<Block> CAT_PLUSHIE = ModBlocks.registerBlock("cat_plushie", () -> new DecoBlock(BlockBehaviour.Properties.of().noOcclusion().sound(SoundType.WOOL)));
    public static final DeferredBlock<Block> ITEM_PIPE = ModBlocks.registerBlock("item_pipe", () -> new PipeBlock(BlockBehaviour.Properties.of().strength(1.0f).noOcclusion(), PipeBlock.Transport.ITEMS));
    public static final DeferredBlock<Block> FLUID_PIPE = ModBlocks.registerBlock("fluid_pipe", () -> new PipeBlock(BlockBehaviour.Properties.of().strength(1.0f).noOcclusion(), PipeBlock.Transport.FLUIDS));
    public static final DeferredBlock<Block> POWER_PIPE = ModBlocks.registerBlock("power_pipe", () -> new PipeBlock(BlockBehaviour.Properties.of().strength(1.0f).noOcclusion(), PipeBlock.Transport.ENERGY));
    public static final DeferredBlock<Block> GENERATOR = ModBlocks.registerBlock("generator", () -> new GeneratorBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> DNA_EXTRACTOR = ModBlocks.registerBlock("dna_extractor", () -> new DNAExtractorBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> FOSSIL_GRINDER = ModBlocks.registerBlock("fossil_grinder", () -> new FossilGrinderBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> FOSSIL_CLEANER = ModBlocks.registerBlock("fossil_cleaner", () -> new FossilCleanerBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> DNA_HYBRIDIZER = ModBlocks.registerBlock("dna_hybridizer", () -> new DNAHybridizerBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> EMBRYONIC_MACHINE = ModBlocks.registerBlock("embryonic_machine", () -> new EmbryonicMachineBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> EMBRYO_CALCIFICATION_MACHINE = ModBlocks.registerBlock("embryo_calcification_machine", () -> new EmbryoCalcificationMachineBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> INCUBATOR = ModBlocks.registerBlock("incubator", () -> new IncubatorBlock(BlockBehaviour.Properties.of().noOcclusion().requiresCorrectToolForDrops().strength(4.0f).noLootTable()));
    public static final DeferredBlock<Block> ROYAL_FERN = ModBlocks.registerBlock("royal_fern", () -> new FlowerBlock(MobEffects.UNLUCK, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM)));
    public static final DeferredBlock<Block> POTTED_ROYAL_FERN = BLOCKS.register("potted_royal_fern", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, ROYAL_FERN, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM)));
    public static final DeferredBlock<Block> HORSETAIL_FERN = ModBlocks.registerBlock("horsetail_fern", () -> new FlowerBlock(MobEffects.UNLUCK, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM)));
    public static final DeferredBlock<Block> POTTED_HORSETAIL_FERN = BLOCKS.register("potted_horsetail_fern", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, HORSETAIL_FERN, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM)));
    public static final DeferredBlock<Block> WESTERN_SWORD_FERN = ModBlocks.registerBlock("western_sword_fern", () -> new FlowerBlock(MobEffects.UNLUCK, 0.0f, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.ALLIUM)));
    public static final DeferredBlock<Block> POTTED_WESTERN_SWORD_FERN = BLOCKS.register("potted_western_sword_fern", () -> new FlowerPotBlock(() -> (FlowerPotBlock)Blocks.FLOWER_POT, WESTERN_SWORD_FERN, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.POTTED_ALLIUM)));
    public static final DeferredBlock<Block> GYPSUM_STONE = ModBlocks.registerBlock("gypsum_stone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> GYPSUM_COBBLESTONE = ModBlocks.registerBlock("gypsum_cobblestone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> GYPSUM_STONE_BRICKS = ModBlocks.registerBlock("gypsum_stone_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> SMOOTH_GYPSUM_STONE = ModBlocks.registerBlock("smooth_gypsum_stone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> LOW_SECURITY_FENCE_POLE = ModBlocks.registerBlock("low_security_fence_pole", () -> new FencePoleBlock(BlockBehaviour.Properties.of().strength(1.0f).noOcclusion().requiresCorrectToolForDrops(), FencePoleBlock.Tier.LOW));
    public static final DeferredBlock<Block> LOW_SECURITY_FENCE_WIRE = ModBlocks.registerBlock("low_security_fence_wire", () -> new FenceWireBlock(BlockBehaviour.Properties.of().strength(0.5f).noOcclusion().requiresCorrectToolForDrops(), FenceWireBlock.Tier.LOW));
    public static final DeferredBlock<Block> MEDIUM_SECURITY_FENCE_POLE = ModBlocks.registerBlock("medium_security_fence_pole", () -> new FencePoleBlock(BlockBehaviour.Properties.of().strength(1.0f).noOcclusion().requiresCorrectToolForDrops(), FencePoleBlock.Tier.MEDIUM));
    public static final DeferredBlock<Block> MEDIUM_SECURITY_FENCE_WIRE = ModBlocks.registerBlock("medium_security_fence_wire", () -> new FenceWireBlock(BlockBehaviour.Properties.of().strength(0.5f).noOcclusion().requiresCorrectToolForDrops(), FenceWireBlock.Tier.MEDIUM));
    public static final DeferredBlock<Block> STONE_FOSSIL = ModBlocks.registerBlock("stone_fossil", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEEPSLATE_FOSSIL = ModBlocks.registerBlock("deepslate_fossil", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> AMBER_ORE = ModBlocks.registerBlock("amber_ore", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> DEEPSLATE_ICE_SHARD_ORE = ModBlocks.registerBlock("deepslate_ice_shard_ore", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> REINFORCED_STONE = ModBlocks.registerBlock("reinforced_stone", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> REINFORCED_STONE_BRICKS = ModBlocks.registerBlock("reinforced_stone_bricks", () -> new Block(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> HATCHED_APATOSAURUS_EGG = ModBlocks.registerBlock("hatched_apatosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.APATOSAURUS));
    public static final DeferredBlock<Block> HATCHED_ALBERTOSAURUS_EGG = ModBlocks.registerBlock("hatched_albertosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.ALBERTOSAURUS));
    public static final DeferredBlock<Block> HATCHED_VELOCIRAPTOR_EGG = ModBlocks.registerBlock("hatched_velociraptor_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.VELOCIRAPTOR));
    public static final DeferredBlock<Block> HATCHED_TYRANNOSAURUS_REX_EGG = ModBlocks.registerBlock("hatched_tyrannosaurus_rex_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.TYRANNOSAURUS_REX));
    public static final DeferredBlock<Block> HATCHED_TRICERATOPS_EGG = ModBlocks.registerBlock("hatched_triceratops_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.TRICERATOPS));
    public static final DeferredBlock<Block> HATCHED_SPINOSAURUS_EGG = ModBlocks.registerBlock("hatched_spinosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.SPINOSAURUS));
    public static final DeferredBlock<Block> HATCHED_PARASAUROLOPHUS_EGG = ModBlocks.registerBlock("hatched_parasaurolophus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.PARASAUROLOPHUS));
    public static final DeferredBlock<Block> HATCHED_INDOMINUS_REX_EGG = ModBlocks.registerBlock("hatched_indominus_rex_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.INDOMINUS_REX));
    public static final DeferredBlock<Block> HATCHED_GALLIMIMUS_EGG = ModBlocks.registerBlock("hatched_gallimimus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.GALLIMIMUS));
    public static final DeferredBlock<Block> HATCHED_DIPLODOCUS_EGG = ModBlocks.registerBlock("hatched_diplodocus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.DIPLODOCUS));
    public static final DeferredBlock<Block> HATCHED_OURANOSAURUS_EGG = ModBlocks.registerBlock("hatched_ouranosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.OURANOSAURUS));
    public static final DeferredBlock<Block> HATCHED_DILOPHOSAURUS_EGG = ModBlocks.registerBlock("hatched_dilophosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.DILOPHOSAURUS));
    public static final DeferredBlock<Block> HATCHED_COMPSOGNATHUS_EGG = ModBlocks.registerBlock("hatched_compsognathus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.COMPSOGNATHUS));
    public static final DeferredBlock<Block> HATCHED_CERATOSAURUS_EGG = ModBlocks.registerBlock("hatched_ceratosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.CERATOSAURUS));
    public static final DeferredBlock<Block> HATCHED_BRACHIOSAURUS_EGG = ModBlocks.registerBlock("hatched_brachiosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.BRACHIOSAURUS));
    public static final DeferredBlock<Block> HATCHED_BARYONYX_EGG = ModBlocks.registerBlock("hatched_baryonyx_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.BARYONYX));
    public static final DeferredBlock<Block> HATCHED_CARNOTAURUS_EGG = ModBlocks.registerBlock("hatched_carnotaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.CARNOTAURUS));
    public static final DeferredBlock<Block> HATCHED_CONCAVENATOR_EGG = ModBlocks.registerBlock("hatched_concavenator_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.CONCAVENATOR));
    public static final DeferredBlock<Block> HATCHED_DEINONYCHUS_EGG = ModBlocks.registerBlock("hatched_deinonychus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.DEINONYCHUS));
    public static final DeferredBlock<Block> HATCHED_EDMONTOSAURUS_EGG = ModBlocks.registerBlock("hatched_edmontosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.EDMONTOSAURUS));
    public static final DeferredBlock<Block> HATCHED_GIGANOTOSAURUS_EGG = ModBlocks.registerBlock("hatched_giganotosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.GIGANOTOSAURUS));
    public static final DeferredBlock<Block> HATCHED_GUANLONG_EGG = ModBlocks.registerBlock("hatched_guanlong_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.GUANLONG));
    public static final DeferredBlock<Block> HATCHED_HERRERASAURUS_EGG = ModBlocks.registerBlock("hatched_herrerasaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.HERRERASAURUS));
    public static final DeferredBlock<Block> HATCHED_MAJUNGASAURUS_EGG = ModBlocks.registerBlock("hatched_majungasaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.MAJUNGASAURUS));
    public static final DeferredBlock<Block> HATCHED_PROCOMPSOGNATHUS_EGG = ModBlocks.registerBlock("hatched_procompsognathus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.PROCOMPSOGNATHUS));
    public static final DeferredBlock<Block> HATCHED_PROTOCERATOPS_EGG = ModBlocks.registerBlock("hatched_protoceratops_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.PROTOCERATOPS));
    public static final DeferredBlock<Block> HATCHED_RUGOPS_EGG = ModBlocks.registerBlock("hatched_rugops_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.RUGOPS));
    public static final DeferredBlock<Block> HATCHED_SHANTUNGOSAURUS_EGG = ModBlocks.registerBlock("hatched_shantungosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.SHANTUNGOSAURUS));
    public static final DeferredBlock<Block> HATCHED_STEGOSAURUS_EGG = ModBlocks.registerBlock("hatched_stegosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.STEGOSAURUS));
    public static final DeferredBlock<Block> HATCHED_STYRACOSAURUS_EGG = ModBlocks.registerBlock("hatched_styracosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.STYRACOSAURUS));
    public static final DeferredBlock<Block> HATCHED_THERIZINOSAURUS_EGG = ModBlocks.registerBlock("hatched_therizinosaurus_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.THERIZINOSAURUS));
    public static final DeferredBlock<Block> HATCHED_DISTORTUS_REX_EGG = ModBlocks.registerBlock("hatched_distortus_rex_egg", () -> new EggBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops(), ModEntities.DISTORTUS_REX));

    public static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> {
            Item.Properties props = new Item.Properties();
            if (block.get() instanceof EggBlock) {
                props = props.rarity(Rarity.RARE).stacksTo(1);
            }
            return new BlockItem((Block)block.get(), props);
        });
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

