/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EggBlock
extends Block {
    private final Supplier<? extends EntityType<? extends Mob>> toSpawn;
    private static final VoxelShape EGG_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);

    public EggBlock(BlockBehaviour.Properties pProperties, Supplier<? extends EntityType<? extends Mob>> toSpawn) {
        super(pProperties);
        this.toSpawn = toSpawn;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return EGG_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return EGG_SHAPE;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.isClientSide) {
            level.scheduleTick(pos, (Block)this, 20);
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Mob mob;
        super.tick(state, level, pos, random);
        EntityType<? extends Mob> type = this.toSpawn.get();
        if (type != null && (mob = (Mob)type.create((Level)level)) != null) {
            Vec3 spawn = Vec3.atCenterOf((Vec3i)pos);
            mob.moveTo(spawn.x, spawn.y + 0.1, spawn.z, level.random.nextFloat() * 360.0f, 0.0f);
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(pos), MobSpawnType.TRIGGERED, null);
            if (mob instanceof AgeableMob) {
                AgeableMob ageable = (AgeableMob)mob;
                ageable.setBaby(true);
            }
            level.addFreshEntity((Entity)mob);
        }
        level.levelEvent(2001, pos, Block.getId((BlockState)state));
        level.removeBlock(pos, false);
    }
}

