/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.custom;

import java.util.Iterator;
import javax.annotation.Nullable;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.entity.custom.PipeBlockEntity;
import net.cmr.jurassicrevived.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;

public class PipeBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<ConnectionType> DOWN = EnumProperty.create((String)"down", ConnectionType.class);
    public static final EnumProperty<ConnectionType> UP = EnumProperty.create((String)"up", ConnectionType.class);
    public static final EnumProperty<ConnectionType> NORTH = EnumProperty.create((String)"north", ConnectionType.class);
    public static final EnumProperty<ConnectionType> SOUTH = EnumProperty.create((String)"south", ConnectionType.class);
    public static final EnumProperty<ConnectionType> WEST = EnumProperty.create((String)"west", ConnectionType.class);
    public static final EnumProperty<ConnectionType> EAST = EnumProperty.create((String)"east", ConnectionType.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private final Transport transport;
    private static final VoxelShape CORE = PipeBlock.box((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape ARM_DOWN = PipeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)6.0, (double)10.0);
    private static final VoxelShape ARM_UP = PipeBlock.box((double)6.0, (double)10.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape ARM_NORTH = PipeBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)6.0);
    private static final VoxelShape ARM_SOUTH = PipeBlock.box((double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape ARM_WEST = PipeBlock.box((double)0.0, (double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0);
    private static final VoxelShape ARM_EAST = PipeBlock.box((double)10.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape CAP_DOWN = PipeBlock.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)1.0, (double)10.0);
    private static final VoxelShape CAP_UP = PipeBlock.box((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape CAP_NORTH = PipeBlock.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)1.0);
    private static final VoxelShape CAP_SOUTH = PipeBlock.box((double)6.0, (double)6.0, (double)15.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape CAP_WEST = PipeBlock.box((double)0.0, (double)6.0, (double)6.0, (double)1.0, (double)10.0, (double)10.0);
    private static final VoxelShape CAP_EAST = PipeBlock.box((double)15.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape[] SHAPES = new VoxelShape[64];

    public PipeBlock(BlockBehaviour.Properties properties, Transport transport) {
        super(properties.noOcclusion());
        this.transport = transport;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(DOWN, (Comparable)((Object)ConnectionType.NONE))).setValue(UP, (Comparable)((Object)ConnectionType.NONE))).setValue(NORTH, (Comparable)((Object)ConnectionType.NONE))).setValue(SOUTH, (Comparable)((Object)ConnectionType.NONE))).setValue(WEST, (Comparable)((Object)ConnectionType.NONE))).setValue(EAST, (Comparable)((Object)ConnectionType.NONE))).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public Transport getTransport() {
        return this.transport;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, WATERLOGGED});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Level level = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        BlockState state = (BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
        for (Direction dir : Direction.values()) {
            state = this.setConnectionForDirection((LevelAccessor)level, pos, state, dir);
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return this.setConnectionForDirection(level, pos, state, direction);
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PipeBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.isClientSide) {
            return null;
        }
        return (lvl, pos, st, be) -> {
            if (be instanceof PipeBlockEntity) {
                PipeBlockEntity pbe = (PipeBlockEntity)be;
                PipeBlockEntity.serverTick(lvl, pos, st, pbe);
            }
        };
    }

    private BlockState setConnectionForDirection(LevelAccessor level, BlockPos pos, BlockState state, Direction dir) {
        EnumProperty<ConnectionType> prop = PipeBlock.getProp(dir);
        ConnectionType connection = this.determineConnection(level, pos, dir);
        return (BlockState)state.setValue(prop, (Comparable)((Object)connection));
    }

    private ConnectionType determineConnection(LevelAccessor level, BlockPos pos, Direction dir) {
        BlockPos neighborPos = pos.relative(dir);
        BlockState neighborState = level.getBlockState(neighborPos);
        Block neighbor = neighborState.getBlock();
        if (neighbor instanceof PipeBlock) {
            PipeBlock otherPipe = (PipeBlock)neighbor;
            if (otherPipe.transport == this.transport) {
                return ConnectionType.PIPE;
            }
        }
        if (level instanceof Level) {
            Level lvl = (Level)level;
            Direction opp = dir.getOpposite();
            switch (this.transport.ordinal()) {
                case 0: {
                    IItemHandler ih = (IItemHandler)lvl.getCapability(Capabilities.ItemHandler.BLOCK, neighborPos, (Object)opp);
                    if (ih == null) break;
                    return ConnectionType.CONNECTOR;
                }
                case 1: {
                    IFluidHandler fh = (IFluidHandler)lvl.getCapability(Capabilities.FluidHandler.BLOCK, neighborPos, (Object)opp);
                    if (fh == null) break;
                    return ConnectionType.CONNECTOR;
                }
                case 2: {
                    IEnergyStorage eh = (IEnergyStorage)lvl.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)opp);
                    if (eh == null) break;
                    return ConnectionType.CONNECTOR;
                }
            }
        }
        return ConnectionType.NONE;
    }

    public static EnumProperty<ConnectionType> getProp(Direction dir) {
        return switch (dir) {
            default -> throw new MatchException(null, null);
            case Direction.DOWN -> DOWN;
            case Direction.UP -> UP;
            case Direction.NORTH -> NORTH;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            case Direction.EAST -> EAST;
        };
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack held = stack;
        if (held.is((Item)ModItems.WRENCH.get())) {
            Direction target = this.getInteractionFace(state, hit, pos);
            if (target == null) {
                return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
            }
            EnumProperty<ConnectionType> prop = PipeBlock.getProp(target);
            ConnectionType val = (ConnectionType)((Object)state.getValue(prop));
            if (val == ConnectionType.CONNECTOR) {
                state = (BlockState)state.setValue(prop, (Comparable)((Object)ConnectionType.CONNECTOR_PULL));
            } else if (val == ConnectionType.CONNECTOR_PULL) {
                state = (BlockState)state.setValue(prop, (Comparable)((Object)ConnectionType.CONNECTOR));
            } else {
                Direction nearest = PipeBlock.nearestConnectedDirection(state, hit, pos);
                if (nearest == null) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                prop = PipeBlock.getProp(nearest);
                val = (ConnectionType)((Object)state.getValue(prop));
                if (val == ConnectionType.CONNECTOR) {
                    state = (BlockState)state.setValue(prop, (Comparable)((Object)ConnectionType.CONNECTOR_PULL));
                } else if (val == ConnectionType.CONNECTOR_PULL) {
                    state = (BlockState)state.setValue(prop, (Comparable)((Object)ConnectionType.CONNECTOR));
                } else {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
            }
            if (!level.isClientSide) {
                level.setBlock(pos, state, 3);
                level.sendBlockUpdated(pos, state, state, 3);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    private Direction getInteractionFace(BlockState state, BlockHitResult hit, BlockPos pos) {
        double z;
        double y;
        Vec3 local = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        double x = Mth.clamp((double)(local.x * 16.0), (double)0.0, (double)16.0);
        if ((PipeBlock.intersects(CAP_UP, x, y = Mth.clamp((double)(local.y * 16.0), (double)0.0, (double)16.0), z = Mth.clamp((double)(local.z * 16.0), (double)0.0, (double)16.0)) || PipeBlock.intersects(ARM_UP, x, y, z)) && state.getValue(UP) != ConnectionType.NONE) {
            return Direction.UP;
        }
        if ((PipeBlock.intersects(CAP_DOWN, x, y, z) || PipeBlock.intersects(ARM_DOWN, x, y, z)) && state.getValue(DOWN) != ConnectionType.NONE) {
            return Direction.DOWN;
        }
        if ((PipeBlock.intersects(CAP_NORTH, x, y, z) || PipeBlock.intersects(ARM_NORTH, x, y, z)) && state.getValue(NORTH) != ConnectionType.NONE) {
            return Direction.NORTH;
        }
        if ((PipeBlock.intersects(CAP_SOUTH, x, y, z) || PipeBlock.intersects(ARM_SOUTH, x, y, z)) && state.getValue(SOUTH) != ConnectionType.NONE) {
            return Direction.SOUTH;
        }
        if ((PipeBlock.intersects(CAP_WEST, x, y, z) || PipeBlock.intersects(ARM_WEST, x, y, z)) && state.getValue(WEST) != ConnectionType.NONE) {
            return Direction.WEST;
        }
        if ((PipeBlock.intersects(CAP_EAST, x, y, z) || PipeBlock.intersects(ARM_EAST, x, y, z)) && state.getValue(EAST) != ConnectionType.NONE) {
            return Direction.EAST;
        }
        return PipeBlock.nearestConnectedDirection(state, x, y, z);
    }

    private static Direction nearestConnectedDirection(BlockState state, BlockHitResult hit, BlockPos pos) {
        Vec3 local = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        double x = Mth.clamp((double)(local.x * 16.0), (double)0.0, (double)16.0);
        double y = Mth.clamp((double)(local.y * 16.0), (double)0.0, (double)16.0);
        double z = Mth.clamp((double)(local.z * 16.0), (double)0.0, (double)16.0);
        return PipeBlock.nearestConnectedDirection(state, x, y, z);
    }

    private static Direction nearestConnectedDirection(BlockState state, double x, double y, double z) {
        Direction best = null;
        double bestScore = Double.NEGATIVE_INFINITY;
        for (Direction d : Direction.values()) {
            double score;
            ConnectionType t = (ConnectionType)((Object)state.getValue(PipeBlock.getProp(d)));
            if (t == ConnectionType.NONE) continue;
            switch (d) {
                default: {
                    throw new MatchException(null, null);
                }
                case UP: {
                    double d2 = y;
                    break;
                }
                case DOWN: {
                    double d2 = 16.0 - y;
                    break;
                }
                case NORTH: {
                    double d2 = 16.0 - z;
                    break;
                }
                case SOUTH: {
                    double d2 = z;
                    break;
                }
                case WEST: {
                    double d2 = 16.0 - x;
                    break;
                }
                case EAST: {
                    double d2 = score = x;
                }
            }
            if (!(score > bestScore)) continue;
            bestScore = score;
            best = d;
        }
        return best;
    }

    private static boolean intersects(VoxelShape shape, double x, double y, double z) {
        Iterator it = shape.toAabbs().iterator();
        if (!it.hasNext()) {
            return false;
        }
        AABB bb = (AABB)it.next();
        return x >= bb.minX && x <= bb.maxX && y >= bb.minY && y <= bb.maxY && z >= bb.minZ && z <= bb.maxZ;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        int mask = 0;
        if (state.getValue(DOWN) != ConnectionType.NONE) {
            mask |= 1;
        }
        if (state.getValue(UP) != ConnectionType.NONE) {
            mask |= 2;
        }
        if (state.getValue(NORTH) != ConnectionType.NONE) {
            mask |= 4;
        }
        if (state.getValue(SOUTH) != ConnectionType.NONE) {
            mask |= 8;
        }
        if (state.getValue(WEST) != ConnectionType.NONE) {
            mask |= 0x10;
        }
        if (state.getValue(EAST) != ConnectionType.NONE) {
            mask |= 0x20;
        }
        return SHAPES[mask];
    }

    public int getMaxItemsPerTick() {
        return Math.max(0, Config.itemsPerSecond / 20);
    }

    public int getMaxFluidPerTick() {
        return Math.max(0, Config.milliBucketsPerSecond / 20);
    }

    public int getMaxEnergyPerTick() {
        return Math.max(0, Config.fePerSecond / 20);
    }

    static {
        for (int mask = 0; mask < SHAPES.length; ++mask) {
            VoxelShape s = CORE;
            if ((mask & 1) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape[])new VoxelShape[]{ARM_DOWN, CAP_DOWN});
            }
            if ((mask & 2) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape[])new VoxelShape[]{ARM_UP, CAP_UP});
            }
            if ((mask & 4) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape[])new VoxelShape[]{ARM_NORTH, CAP_NORTH});
            }
            if ((mask & 8) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape[])new VoxelShape[]{ARM_SOUTH, CAP_SOUTH});
            }
            if ((mask & 0x10) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape[])new VoxelShape[]{ARM_WEST, CAP_WEST});
            }
            if ((mask & 0x20) != 0) {
                s = Shapes.or((VoxelShape)s, (VoxelShape[])new VoxelShape[]{ARM_EAST, CAP_EAST});
            }
            PipeBlock.SHAPES[mask] = s;
        }
    }

    public static enum Transport {
        ITEMS,
        FLUIDS,
        ENERGY;

    }

    public static enum ConnectionType implements StringRepresentable
    {
        NONE,
        PIPE,
        CONNECTOR,
        CONNECTOR_PULL;


        public String getSerializedName() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "none";
                case 1 -> "pipe";
                case 2 -> "connector";
                case 3 -> "connector_pull";
            };
        }
    }
}

