/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.block.entity.custom.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.recipe.FossilCleanerRecipe;
import net.cmr.jurassicrevived.recipe.FossilCleanerRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.custom.FossilCleanerMenu;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FossilCleanerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(5){

        protected void onContentsChanged(int slot) {
            FossilCleanerBlockEntity.this.setChanged();
            if (!FossilCleanerBlockEntity.this.level.isClientSide()) {
                FossilCleanerBlockEntity.this.level.sendBlockUpdated(FossilCleanerBlockEntity.this.getBlockPos(), FossilCleanerBlockEntity.this.getBlockState(), FossilCleanerBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.getItem() == Items.WATER_BUCKET) {
                        yield true;
                    }
                    IFluidHandlerItem fh = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM, null);
                    if (fh == null || fh.getTanks() <= 0) {
                        yield false;
                    }
                    boolean hasWater = false;
                    for (int t = 0; t < fh.getTanks(); ++t) {
                        FluidStack fs = fh.getFluidInTank(t);
                        if (fs.isEmpty() || !fs.getFluid().is(FluidTags.WATER)) continue;
                        hasWater = true;
                        break;
                    }
                    yield hasWater;
                }
                case 1 -> {
                    if (stack.getItem() == ((Block)ModBlocks.STONE_FOSSIL.get()).asItem() || stack.getItem() == ((Block)ModBlocks.DEEPSLATE_FOSSIL.get()).asItem()) {
                        yield true;
                    }
                    yield false;
                }
                case 2, 3, 4 -> true;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int WATER_SLOT = 0;
    private static final int FOSSILBLOCK_SLOT = 1;
    private static final int OUTPUT_SLOT_1 = 2;
    private static final int OUTPUT_SLOT_2 = 3;
    private static final int OUTPUT_SLOT_3 = 4;
    private final EnumMap<Direction, IItemHandler> sidedHandlers = new EnumMap(Direction.class);
    private ItemStack lockedOutput = ItemStack.EMPTY;
    private String lastInputSignature = "";
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 200;
    private int DEFAULT_MAX_PROGRESS = 200;
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();
    private static final int WATER_CRAFT_AMOUNT = 250;
    private final FluidTank FLUID_TANK = this.createFluidTank();
    private final IFluidHandler noDrainView = new IFluidHandler(){

        public int getTanks() {
            return FossilCleanerBlockEntity.this.FLUID_TANK.getTanks();
        }

        public FluidStack getFluidInTank(int tank) {
            return FossilCleanerBlockEntity.this.FLUID_TANK.getFluidInTank(tank);
        }

        public int getTankCapacity(int tank) {
            return FossilCleanerBlockEntity.this.FLUID_TANK.getTankCapacity(tank);
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return FossilCleanerBlockEntity.this.FLUID_TANK.isFluidValid(tank, stack);
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return FossilCleanerBlockEntity.this.FLUID_TANK.fill(resource, action);
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            return FluidStack.EMPTY;
        }
    };

    private ModEnergyStorage createEnergyStorage() {
        if (Config.REQUIRE_POWER) {
            return new ModEnergyStorage(16000, (int)ENERGY_TRANSFER_RATE){

                @Override
                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public boolean canExtract() {
                    return false;
                }

                @Override
                public void onEnergyChanged() {
                    FossilCleanerBlockEntity.this.setChanged();
                    if (FossilCleanerBlockEntity.this.getLevel() != null) {
                        FossilCleanerBlockEntity.this.getLevel().sendBlockUpdated(FossilCleanerBlockEntity.this.getBlockPos(), FossilCleanerBlockEntity.this.getBlockState(), FossilCleanerBlockEntity.this.getBlockState(), 3);
                    }
                }
            };
        }
        return null;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (Config.REQUIRE_POWER) {
            return this.ENERGY_STORAGE;
        }
        return null;
    }

    private FluidTank createFluidTank() {
        return new FluidTank(16000){

            protected void onContentsChanged() {
                FossilCleanerBlockEntity.this.setChanged();
                if (!FossilCleanerBlockEntity.this.level.isClientSide()) {
                    FossilCleanerBlockEntity.this.level.sendBlockUpdated(FossilCleanerBlockEntity.this.getBlockPos(), FossilCleanerBlockEntity.this.getBlockState(), FossilCleanerBlockEntity.this.getBlockState(), 3);
                }
            }

            public boolean isFluidValid(FluidStack stack) {
                return stack != null && !stack.isEmpty() && stack.getFluid().is(FluidTags.WATER);
            }
        };
    }

    public IFluidHandler getFluidTank(@Nullable Direction direction) {
        if (direction != null) {
            return this.noDrainView;
        }
        return this.FLUID_TANK;
    }

    public FluidStack getFluid() {
        return this.FLUID_TANK.getFluid();
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        if (!this.getFluid().isEmpty()) {
            return false;
        }
        return this.progress <= 0;
    }

    public FossilCleanerBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.FOSSIL_CLEANER_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> FossilCleanerBlockEntity.this.progress;
                    case 1 -> FossilCleanerBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        FossilCleanerBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        FossilCleanerBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        return this.sidedHandlers.computeIfAbsent(direction, dir -> new IItemHandler(){

            public int getSlots() {
                return FossilCleanerBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return FossilCleanerBlockEntity.this.itemHandler.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if ((slot == 1 || slot == 0) && FossilCleanerBlockEntity.this.itemHandler.isItemValid(slot, stack)) {
                    return FossilCleanerBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 2 || slot == 3 || slot == 4) {
                    return FossilCleanerBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                if (slot == 0) {
                    return 1;
                }
                return FossilCleanerBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return (slot == 1 || slot == 0) && FossilCleanerBlockEntity.this.itemHandler.isItemValid(slot, stack);
            }
        });
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jurassicrevived.fossil_cleaner");
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, FossilCleanerBlockEntity be) {
        if (!level.isClientSide) {
            be.tick(level, pos, state);
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.level != null && !this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider registries) {
        CompoundTag tag = pkt.getTag();
        if (tag != null) {
            this.loadAdditional(tag, registries);
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider registries) {
        this.loadAdditional(tag, registries);
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FossilCleanerMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("fossil_cleaner.progress", this.progress);
        tag.putInt("fossil_cleaner.max_progress", this.maxProgress);
        if (Config.REQUIRE_POWER) {
            tag.putInt("fossil_cleaner.energy", this.ENERGY_STORAGE.getEnergyStored());
        }
        tag = this.FLUID_TANK.writeToNBT(registries, tag);
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("fossil_cleaner.progress");
        this.maxProgress = tag.getInt("fossil_cleaner.max_progress");
        if (Config.REQUIRE_POWER) {
            this.ENERGY_STORAGE.setEnergy(tag.getInt("fossil_cleaner.energy"));
        }
        this.FLUID_TANK.readFromNBT(registries, tag);
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        if (Config.REQUIRE_POWER) {
            this.pullEnergyFromNeighbors();
        }
        if (level.isClientSide) {
            return;
        }
        this.transferFluidToTank();
        Optional<RecipeHolder<FossilCleanerRecipe>> recipeOpt = this.getCurrentRecipe();
        if (recipeOpt.isEmpty()) {
            this.resetProgress();
            this.lockedOutput = ItemStack.EMPTY;
            this.lastInputSignature = "";
            return;
        }
        String currentSignature = FossilCleanerBlockEntity.signatureOf(this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(0));
        if (this.progress == 0 && (this.lockedOutput.isEmpty() || !currentSignature.equals(this.lastInputSignature))) {
            this.lockedOutput = this.determineOutputForCurrentInputs().copy();
            this.lastInputSignature = currentSignature;
        }
        ItemStack prospectiveOutput = this.lockedOutput.isEmpty() ? this.determineOutputForCurrentInputs() : this.lockedOutput;
        boolean canOutputNow = !prospectiveOutput.isEmpty() && this.canInsertItemIntoOutputSlot(prospectiveOutput) && this.canInsertAmountIntoOutputSlot(prospectiveOutput);
        boolean hasWaterForCraft = this.hasEnoughFluidToCraft();
        if (!prospectiveOutput.isEmpty() && canOutputNow && hasWaterForCraft) {
            if (Config.REQUIRE_POWER && !this.consumeEnergyPerTick(64)) {
                FossilCleanerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return;
            }
            this.increaseCraftingProgress();
            FossilCleanerBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.extractFluidForCrafting();
                this.resetProgress();
                this.lockedOutput = ItemStack.EMPTY;
                this.lastInputSignature = "";
            }
        } else {
            this.resetProgress();
        }
    }

    private void pullEnergyFromNeighbors() {
        if (!Config.REQUIRE_POWER) {
            return;
        }
        if (this.level == null) {
            return;
        }
        int capacityLeft = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        if (capacityLeft <= 0) {
            return;
        }
        int remaining = Math.min((int)ENERGY_TRANSFER_RATE, capacityLeft);
        if (remaining <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int actuallyExtracted;
            int canAccept;
            int canExtract;
            if (remaining <= 0) break;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            IEnergyStorage source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)dir.getOpposite());
            if (source == null) {
                source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, null);
            }
            if (source == null || (canExtract = source.extractEnergy(remaining, true)) <= 0 || (canAccept = this.ENERGY_STORAGE.receiveEnergy(canExtract, true)) <= 0 || (actuallyExtracted = source.extractEnergy(canAccept, false)) <= 0) continue;
            int actuallyAccepted = this.ENERGY_STORAGE.receiveEnergy(actuallyExtracted, false);
            if (actuallyAccepted < actuallyExtracted) {
                source.receiveEnergy(actuallyExtracted - actuallyAccepted, false);
            }
            remaining -= actuallyAccepted;
        }
    }

    private void extractFluidForCrafting() {
        this.FLUID_TANK.drain(250, IFluidHandler.FluidAction.EXECUTE);
    }

    private void transferFluidToTank() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        if (stack.getItem() == Items.WATER_BUCKET) {
            FluidActionResult result;
            int space = this.FLUID_TANK.getCapacity() - this.FLUID_TANK.getFluidAmount();
            if (space >= 1000 && (result = FluidUtil.tryEmptyContainer((ItemStack)stack, (IFluidHandler)this.FLUID_TANK, (int)Integer.MAX_VALUE, null, (boolean)true)).isSuccess()) {
                this.itemHandler.setStackInSlot(0, result.getResult());
                this.setChanged();
            }
            return;
        }
        IFluidHandlerItem fh = (IFluidHandlerItem)stack.getCapability(Capabilities.FluidHandler.ITEM, null);
        if (fh == null || fh.getTanks() <= 0) {
            return;
        }
        int availableWater = 0;
        Fluid chosenWaterFluid = null;
        for (int t = 0; t < fh.getTanks(); ++t) {
            FluidStack inTank = fh.getFluidInTank(t);
            if (inTank.isEmpty() || !inTank.getFluid().is(FluidTags.WATER)) continue;
            availableWater += inTank.getAmount();
            if (chosenWaterFluid != null) continue;
            chosenWaterFluid = inTank.getFluid();
        }
        if (availableWater <= 0 || chosenWaterFluid == null) {
            return;
        }
        int space = this.FLUID_TANK.getCapacity() - this.FLUID_TANK.getFluidAmount();
        if (space <= 0) {
            return;
        }
        int toTransfer = Math.min(space, availableWater);
        if (toTransfer <= 0) {
            return;
        }
        FluidStack simDrain = new FluidStack(chosenWaterFluid, toTransfer);
        FluidStack drainable = fh.drain(simDrain, IFluidHandler.FluidAction.SIMULATE);
        if (drainable.isEmpty() || drainable.getAmount() <= 0 || !drainable.getFluid().is(FluidTags.WATER)) {
            return;
        }
        int acceptable = this.FLUID_TANK.fill(drainable, IFluidHandler.FluidAction.SIMULATE);
        if (acceptable <= 0) {
            return;
        }
        FluidStack actuallyDrained = fh.drain(new FluidStack(chosenWaterFluid, acceptable), IFluidHandler.FluidAction.EXECUTE);
        if (actuallyDrained.isEmpty()) {
            return;
        }
        int filled = this.FLUID_TANK.fill(actuallyDrained, IFluidHandler.FluidAction.EXECUTE);
        if (filled <= 0) {
            return;
        }
        if (fh instanceof IFluidHandlerItem) {
            IFluidHandlerItem itemHandlerCap = fh;
            this.itemHandler.setStackInSlot(0, itemHandlerCap.getContainer());
        } else {
            this.itemHandler.setStackInSlot(0, stack);
        }
        this.setChanged();
    }

    private boolean hasEnoughFluidToCraft() {
        return this.FLUID_TANK.getFluidAmount() >= 250;
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = this.DEFAULT_MAX_PROGRESS;
    }

    private void craftItem() {
        int[] slots;
        ItemStack output;
        Optional<RecipeHolder<FossilCleanerRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack itemStack = output = this.lockedOutput.isEmpty() ? ((FossilCleanerRecipe)recipe.get().value()).output().copy() : this.lockedOutput.copy();
        if (output.isEmpty()) {
            return;
        }
        if (!this.canInsertItemIntoOutputSlot(output) || !this.canInsertAmountIntoOutputSlot(output)) {
            return;
        }
        for (int slot : slots = new int[]{2, 3, 4}) {
            ItemStack current = this.itemHandler.getStackInSlot(slot);
            if (current.isEmpty()) {
                this.itemHandler.setStackInSlot(slot, output.copy());
                this.itemHandler.extractItem(1, 1, false);
                return;
            }
            if (current.getItem() != output.getItem() || current.getCount() + output.getCount() > current.getMaxStackSize()) continue;
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)current.getItem(), current.getCount() + output.getCount()));
            this.itemHandler.extractItem(1, 1, false);
            return;
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotsEmptyorReceivable() {
        return this.itemHandler.getStackInSlot(2).isEmpty() || this.itemHandler.getStackInSlot(3).isEmpty() || this.itemHandler.getStackInSlot(4).isEmpty() || this.itemHandler.getStackInSlot(2).getCount() < this.itemHandler.getStackInSlot(2).getMaxStackSize() || this.itemHandler.getStackInSlot(3).getCount() < this.itemHandler.getStackInSlot(3).getMaxStackSize() || this.itemHandler.getStackInSlot(4).getCount() < this.itemHandler.getStackInSlot(4).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<FossilCleanerRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = this.lockedOutput.isEmpty() ? ((FossilCleanerRecipe)recipe.get().value()).output() : this.lockedOutput;
        return !output.isEmpty() && this.canInsertAmountIntoOutputSlot(output) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<FossilCleanerRecipe>> getCurrentRecipe() {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.FOSSIL_CLEANER_RECIPE_TYPE.get(), (RecipeInput)new FossilCleanerRecipeInput(this.itemHandler.getStackInSlot(1), this.itemHandler.getStackInSlot(0)), this.level);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack output) {
        int[] slots;
        int toInsert = output.getCount();
        for (int slot : slots = new int[]{2, 3, 4}) {
            int space;
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!(stack.isEmpty() ? toInsert <= 8 : stack.getItem() == output.getItem() && (space = stack.getMaxStackSize() - stack.getCount()) >= toInsert)) continue;
            return true;
        }
        return false;
    }

    private ItemStack determineOutputForCurrentInputs() {
        Optional<RecipeHolder<FossilCleanerRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return ItemStack.EMPTY;
        }
        ItemStack randomFossil = this.pickWeightedRandomFossilFromTag((FossilCleanerRecipe)recipe.get().value());
        int count = Math.max(1, ((FossilCleanerRecipe)recipe.get().value()).output().getCount());
        if (!randomFossil.isEmpty()) {
            randomFossil.setCount(count);
            return randomFossil;
        }
        return ((FossilCleanerRecipe)recipe.get().value()).output().copy();
    }

    private ItemStack pickWeightedRandomFossilFromTag(FossilCleanerRecipe recipe) {
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        Registry registry = this.level.registryAccess().registryOrThrow(Registries.ITEM);
        Optional tagged = registry.getTag(ModTags.Items.FOSSILS);
        if (tagged.isEmpty()) {
            return ItemStack.EMPTY;
        }
        HolderSet.Named holderSet = (HolderSet.Named)tagged.get();
        int totalWeight = 0;
        ArrayList<Item> items = new ArrayList<Item>();
        ArrayList<Integer> weights = new ArrayList<Integer>();
        for (Holder holder : holderSet) {
            Item item = (Item)holder.value();
            int w = Math.max(0, recipe.getWeightFor(item));
            if (w <= 0) continue;
            items.add(item);
            weights.add(w);
            totalWeight += w;
        }
        if (totalWeight <= 0) {
            return ItemStack.EMPTY;
        }
        int roll = this.level.random.nextInt(totalWeight);
        int acc = 0;
        for (int i = 0; i < items.size(); ++i) {
            if (roll >= (acc += ((Integer)weights.get(i)).intValue())) continue;
            return new ItemStack((ItemLike)items.get(i));
        }
        return ItemStack.EMPTY;
    }

    private static String signatureOf(ItemStack fossilblock, ItemStack water) {
        return FossilCleanerBlockEntity.stackSig(fossilblock) + "#" + FossilCleanerBlockEntity.stackSig(water);
    }

    private static String stackSig(ItemStack s) {
        if (s.isEmpty()) {
            return "empty";
        }
        String id = s.getItem().builtInRegistryHolder().key().location().toString();
        return id + "x" + s.getCount();
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        int[] slots;
        for (int slot : slots = new int[]{2, 3, 4}) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!stack.isEmpty() && stack.getItem() != output.getItem()) continue;
            return true;
        }
        return false;
    }

    private boolean consumeEnergyPerTick(int fe) {
        if (fe <= 0) {
            return true;
        }
        if (this.ENERGY_STORAGE.getEnergyStored() >= fe) {
            this.ENERGY_STORAGE.extractEnergy(fe, false);
            return true;
        }
        return false;
    }
}

