/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.entity.custom.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.recipe.FossilGrinderRecipe;
import net.cmr.jurassicrevived.recipe.FossilGrinderRecipeInput;
import net.cmr.jurassicrevived.recipe.ModRecipes;
import net.cmr.jurassicrevived.screen.custom.FossilGrinderMenu;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FossilGrinderBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(4){

        protected void onContentsChanged(int slot) {
            FossilGrinderBlockEntity.this.setChanged();
            if (!FossilGrinderBlockEntity.this.level.isClientSide()) {
                FossilGrinderBlockEntity.this.level.sendBlockUpdated(FossilGrinderBlockEntity.this.getBlockPos(), FossilGrinderBlockEntity.this.getBlockState(), FossilGrinderBlockEntity.this.getBlockState(), 3);
            }
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return switch (slot) {
                case 0 -> {
                    if (stack.is(ModTags.Items.FOSSILS) || stack.is(ModTags.Items.SKULLS)) {
                        yield true;
                    }
                    yield false;
                }
                case 1, 2, 3 -> false;
                default -> super.isItemValid(slot, stack);
            };
        }
    };
    private static final int FOSSIL_SLOT = 0;
    private static final int OUTPUT_SLOT_1 = 1;
    private static final int OUTPUT_SLOT_2 = 2;
    private static final int OUTPUT_SLOT_3 = 3;
    private final EnumMap<Direction, IItemHandler> sidedHandlers = new EnumMap(Direction.class);
    private ItemStack lockedOutput = ItemStack.EMPTY;
    private String lastInputSignature = "";
    private final ContainerData data;
    private int progress = 0;
    private int maxProgress = 200;
    private final int DEFAULT_MAX_PROGRESS = 200;
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    private ModEnergyStorage createEnergyStorage() {
        if (Config.REQUIRE_POWER) {
            return new ModEnergyStorage(16000, (int)ENERGY_TRANSFER_RATE){

                @Override
                public int extractEnergy(int maxExtract, boolean simulate) {
                    return 0;
                }

                public boolean canExtract() {
                    return false;
                }

                @Override
                public void onEnergyChanged() {
                    FossilGrinderBlockEntity.this.setChanged();
                    if (FossilGrinderBlockEntity.this.getLevel() != null) {
                        FossilGrinderBlockEntity.this.getLevel().sendBlockUpdated(FossilGrinderBlockEntity.this.getBlockPos(), FossilGrinderBlockEntity.this.getBlockState(), FossilGrinderBlockEntity.this.getBlockState(), 3);
                    }
                }
            };
        }
        return null;
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        if (Config.REQUIRE_POWER) {
            return this.ENERGY_STORAGE;
        }
        return null;
    }

    public FossilGrinderBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.FOSSIL_GRINDER_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int pIndex) {
                return switch (pIndex) {
                    case 0 -> FossilGrinderBlockEntity.this.progress;
                    case 1 -> FossilGrinderBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int pIndex, int pValue) {
                switch (pIndex) {
                    case 0: {
                        FossilGrinderBlockEntity.this.progress = pValue;
                        break;
                    }
                    case 1: {
                        FossilGrinderBlockEntity.this.maxProgress = pValue;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        return this.sidedHandlers.computeIfAbsent(direction, dir -> new IItemHandler(){

            public int getSlots() {
                return FossilGrinderBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return FossilGrinderBlockEntity.this.itemHandler.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot == 0 && FossilGrinderBlockEntity.this.itemHandler.isItemValid(slot, stack)) {
                    return FossilGrinderBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
                }
                return stack;
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                if (slot == 1 || slot == 2 || slot == 3) {
                    return FossilGrinderBlockEntity.this.itemHandler.extractItem(slot, amount, simulate);
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return FossilGrinderBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return slot == 0 && FossilGrinderBlockEntity.this.itemHandler.isItemValid(slot, stack);
            }
        });
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jurassicrevived.fossil_grinder");
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return this.progress == 0;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new FossilGrinderMenu(i, inventory, this, this.data);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("fossil_grinder.progress", this.progress);
        tag.putInt("fossil_grinder.max_progress", this.maxProgress);
        if (Config.REQUIRE_POWER) {
            tag.putInt("fossil_grinder.energy", this.ENERGY_STORAGE.getEnergyStored());
        }
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("inventory"));
        this.progress = tag.getInt("fossil_grinder.progress");
        this.maxProgress = tag.getInt("fossil_grinder.max_progress");
        if (Config.REQUIRE_POWER) {
            this.ENERGY_STORAGE.setEnergy(tag.getInt("fossil_grinder.energy"));
        }
    }

    public void drops() {
        SimpleContainer inv = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inv.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inv);
    }

    public void tick(Level level, BlockPos pos, BlockState state) {
        boolean canOutputNow;
        Optional<RecipeHolder<FossilGrinderRecipe>> recipeOpt;
        if (Config.REQUIRE_POWER) {
            this.pullEnergyFromNeighbors();
        }
        if ((recipeOpt = this.getCurrentRecipe()).isEmpty()) {
            this.resetProgress();
            this.lockedOutput = ItemStack.EMPTY;
            this.lastInputSignature = "";
            return;
        }
        String currentSignature = FossilGrinderBlockEntity.signatureOf(this.itemHandler.getStackInSlot(0));
        if (this.progress == 0 && (this.lockedOutput.isEmpty() || !currentSignature.equals(this.lastInputSignature))) {
            this.lockedOutput = this.determineOutputForCurrentInputs().copy();
            this.lastInputSignature = currentSignature;
        }
        ItemStack prospectiveOutput = this.lockedOutput.isEmpty() ? this.determineOutputForCurrentInputs() : this.lockedOutput;
        boolean bl = canOutputNow = !prospectiveOutput.isEmpty() && this.canInsertItemIntoOutputSlot(prospectiveOutput) && this.canInsertAmountIntoOutputSlot(prospectiveOutput);
        if (!prospectiveOutput.isEmpty() && canOutputNow) {
            if (Config.REQUIRE_POWER && !this.consumeEnergyPerTick(64)) {
                FossilGrinderBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
                return;
            }
            this.increaseCraftingProgress();
            FossilGrinderBlockEntity.setChanged((Level)level, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
                this.lockedOutput = ItemStack.EMPTY;
                this.lastInputSignature = "";
            }
        } else {
            this.resetProgress();
        }
    }

    private void pullEnergyFromNeighbors() {
        if (!Config.REQUIRE_POWER) {
            return;
        }
        if (this.level == null) {
            return;
        }
        int capacityLeft = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        if (capacityLeft <= 0) {
            return;
        }
        int remaining = Math.min((int)ENERGY_TRANSFER_RATE, capacityLeft);
        if (remaining <= 0) {
            return;
        }
        for (Direction dir : Direction.values()) {
            int actuallyExtracted;
            int canAccept;
            int canExtract;
            if (remaining <= 0) break;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            IEnergyStorage source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)dir.getOpposite());
            if (source == null) {
                source = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, null);
            }
            if (source == null || (canExtract = source.extractEnergy(remaining, true)) <= 0 || (canAccept = this.ENERGY_STORAGE.receiveEnergy(canExtract, true)) <= 0 || (actuallyExtracted = source.extractEnergy(canAccept, false)) <= 0) continue;
            int actuallyAccepted = this.ENERGY_STORAGE.receiveEnergy(actuallyExtracted, false);
            if (actuallyAccepted < actuallyExtracted) {
                source.receiveEnergy(actuallyExtracted - actuallyAccepted, false);
            }
            remaining -= actuallyAccepted;
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 200;
    }

    private void craftItem() {
        int[] slots;
        ItemStack output;
        Optional<RecipeHolder<FossilGrinderRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return;
        }
        ItemStack itemStack = output = this.lockedOutput.isEmpty() ? ((FossilGrinderRecipe)recipe.get().value()).output().copy() : this.lockedOutput.copy();
        if (output.isEmpty()) {
            return;
        }
        if (!this.canInsertItemIntoOutputSlot(output) || !this.canInsertAmountIntoOutputSlot(output)) {
            return;
        }
        for (int slot : slots = new int[]{1, 2, 3}) {
            ItemStack current = this.itemHandler.getStackInSlot(slot);
            if (current.isEmpty()) {
                this.itemHandler.setStackInSlot(slot, output.copy());
                this.itemHandler.extractItem(0, 1, false);
                return;
            }
            if (current.getItem() != output.getItem() || current.getCount() + output.getCount() > current.getMaxStackSize()) continue;
            this.itemHandler.setStackInSlot(slot, new ItemStack((ItemLike)current.getItem(), current.getCount() + output.getCount()));
            this.itemHandler.extractItem(0, 1, false);
            return;
        }
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean isOutputSlotsEmptyorReceivable() {
        return this.itemHandler.getStackInSlot(1).isEmpty() || this.itemHandler.getStackInSlot(2).isEmpty() || this.itemHandler.getStackInSlot(3).isEmpty() || this.itemHandler.getStackInSlot(1).getCount() < this.itemHandler.getStackInSlot(1).getMaxStackSize() || this.itemHandler.getStackInSlot(2).getCount() < this.itemHandler.getStackInSlot(2).getMaxStackSize() || this.itemHandler.getStackInSlot(3).getCount() < this.itemHandler.getStackInSlot(3).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<FossilGrinderRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = this.lockedOutput.isEmpty() ? ((FossilGrinderRecipe)recipe.get().value()).output() : this.lockedOutput;
        return !output.isEmpty() && this.canInsertAmountIntoOutputSlot(output) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<FossilGrinderRecipe>> getCurrentRecipe() {
        assert (this.level != null);
        return this.level.getRecipeManager().getRecipeFor((RecipeType)ModRecipes.FOSSIL_GRINDER_RECIPE_TYPE.get(), (RecipeInput)new FossilGrinderRecipeInput(Collections.singletonList(this.itemHandler.getStackInSlot(0))), this.level);
    }

    private boolean canInsertAmountIntoOutputSlot(ItemStack output) {
        int[] slots;
        int toInsert = output.getCount();
        for (int slot : slots = new int[]{1, 2, 3}) {
            int space;
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!(stack.isEmpty() ? toInsert <= 8 : stack.getItem() == output.getItem() && (space = stack.getMaxStackSize() - stack.getCount()) >= toInsert)) continue;
            return true;
        }
        return false;
    }

    private ItemStack determineOutputForCurrentInputs() {
        Optional<RecipeHolder<FossilGrinderRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return ItemStack.EMPTY;
        }
        FossilGrinderRecipe r = (FossilGrinderRecipe)recipe.get().value();
        if (!r.weights().isEmpty()) {
            ItemStack rolled = this.pickWeightedFromRecipeOutputs(r);
            int count = Math.max(1, r.output().getCount());
            if (!rolled.isEmpty()) {
                rolled.setCount(count);
                return rolled;
            }
        }
        return r.output().copy();
    }

    private ItemStack pickWeightedFromRecipeOutputs(FossilGrinderRecipe recipe) {
        if (this.level == null) {
            return ItemStack.EMPTY;
        }
        Map<ResourceLocation, Integer> map = recipe.weights();
        int total = 0;
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(map.size());
        ArrayList<Integer> ws = new ArrayList<Integer>(map.size());
        for (Map.Entry<ResourceLocation, Integer> e : map.entrySet()) {
            int w = Math.max(0, e.getValue());
            if (w <= 0) continue;
            ids.add(e.getKey());
            ws.add(w);
            total += w;
        }
        if (total <= 0) {
            return ItemStack.EMPTY;
        }
        int roll = this.level.random.nextInt(total);
        int acc = 0;
        for (int i = 0; i < ids.size(); ++i) {
            if (roll >= (acc += ((Integer)ws.get(i)).intValue())) continue;
            Item item = (Item)BuiltInRegistries.ITEM.get((ResourceLocation)ids.get(i));
            if (item == null) break;
            return new ItemStack((ItemLike)item);
        }
        return ItemStack.EMPTY;
    }

    private static String signatureOf(ItemStack fossil) {
        return FossilGrinderBlockEntity.stackSig(fossil);
    }

    private static String stackSig(ItemStack s) {
        if (s.isEmpty()) {
            return "empty";
        }
        String id = s.getItem().builtInRegistryHolder().key().location().toString();
        return id + "x" + s.getCount();
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        int[] slots;
        for (int slot : slots = new int[]{1, 2, 3}) {
            ItemStack stack = this.itemHandler.getStackInSlot(slot);
            if (!stack.isEmpty() && stack.getItem() != output.getItem()) continue;
            return true;
        }
        return false;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    private boolean consumeEnergyPerTick(int fe) {
        if (fe <= 0) {
            return true;
        }
        if (this.ENERGY_STORAGE.getEnergyStored() >= fe) {
            this.ENERGY_STORAGE.extractEnergy(fe, false);
            return true;
        }
        return false;
    }
}

