/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.block.entity.custom;

import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.entity.custom.ModBlockEntities;
import net.cmr.jurassicrevived.block.entity.energy.ModEnergyStorage;
import net.cmr.jurassicrevived.screen.custom.GeneratorMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.AbstractFurnaceBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneratorBlockEntity
extends BlockEntity
implements MenuProvider {
    public final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            GeneratorBlockEntity.this.setChanged();
            if (!GeneratorBlockEntity.this.level.isClientSide()) {
                GeneratorBlockEntity.this.level.sendBlockUpdated(GeneratorBlockEntity.this.getBlockPos(), GeneratorBlockEntity.this.getBlockState(), GeneratorBlockEntity.this.getBlockState(), 3);
            }
        }
    };
    public static final int INPUT_SLOT = 0;
    protected final ContainerData data;
    private int burnTime = 0;
    private int burnTimeTotal = 0;
    private boolean isBurning = false;
    private static final float ENERGY_TRANSFER_RATE = (float)Config.fePerSecond / 20.0f;
    private final ModEnergyStorage ENERGY_STORAGE = this.createEnergyStorage();

    private ModEnergyStorage createEnergyStorage() {
        return new ModEnergyStorage(256000, (int)ENERGY_TRANSFER_RATE){

            @Override
            public int receiveEnergy(int maxReceive, boolean simulate) {
                return 0;
            }

            public boolean canReceive() {
                return false;
            }

            @Override
            public void onEnergyChanged() {
                GeneratorBlockEntity.this.setChanged();
                if (GeneratorBlockEntity.this.getLevel() != null) {
                    GeneratorBlockEntity.this.getLevel().sendBlockUpdated(GeneratorBlockEntity.this.getBlockPos(), GeneratorBlockEntity.this.getBlockState(), GeneratorBlockEntity.this.getBlockState(), 3);
                }
            }
        };
    }

    public GeneratorBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntities.GENERATOR_BE.get(), pos, blockState);
        this.data = new ContainerData(){

            public int get(int i) {
                return switch (i) {
                    case 0 -> GeneratorBlockEntity.this.burnTime;
                    case 1 -> GeneratorBlockEntity.this.burnTimeTotal;
                    default -> 0;
                };
            }

            public void set(int i, int i1) {
                switch (i) {
                    case 0: {
                        GeneratorBlockEntity.this.burnTime = i1;
                        break;
                    }
                    case 1: {
                        GeneratorBlockEntity.this.burnTimeTotal = i1;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    private void generateEnergyTick() {
        int space = this.ENERGY_STORAGE.getMaxEnergyStored() - this.ENERGY_STORAGE.getEnergyStored();
        int toAdd = Math.min(100, Math.max(0, space));
        if (toAdd > 0) {
            this.ENERGY_STORAGE.setEnergy(this.ENERGY_STORAGE.getEnergyStored() + toAdd);
            this.ENERGY_STORAGE.onEnergyChanged();
            if (this.level != null && !this.level.isClientSide) {
                this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        }
    }

    public IEnergyStorage getEnergyStorage(@Nullable Direction direction) {
        return this.ENERGY_STORAGE;
    }

    public IItemHandler getItemHandler(@Nullable Direction direction) {
        if (direction == null) {
            return this.itemHandler;
        }
        return new IItemHandler(){

            public int getSlots() {
                return GeneratorBlockEntity.this.itemHandler.getSlots();
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return GeneratorBlockEntity.this.itemHandler.getStackInSlot(slot);
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                if (slot != 0 || stack.isEmpty()) {
                    return stack;
                }
                int burn = AbstractFurnaceBlockEntity.getFuel().getOrDefault(stack.getItem(), 0);
                if (burn <= 0) {
                    return stack;
                }
                return GeneratorBlockEntity.this.itemHandler.insertItem(slot, stack, simulate);
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                return GeneratorBlockEntity.this.itemHandler.getSlotLimit(slot);
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                if (slot != 0 || stack.isEmpty()) {
                    return false;
                }
                int burn = AbstractFurnaceBlockEntity.getFuel().getOrDefault(stack.getItem(), 0);
                return burn > 0;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.jurassicrevived.generator");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        return new GeneratorMenu(i, inventory, this, this.data);
    }

    public boolean isEmptyForDrop() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            if (this.itemHandler.getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return !this.isBurning;
    }

    public void tick(Level level1, BlockPos blockPos, BlockState blockState) {
        boolean storageFull;
        boolean bl = storageFull = this.ENERGY_STORAGE.getEnergyStored() >= this.ENERGY_STORAGE.getMaxEnergyStored();
        if (!storageFull && !this.isBurningFuel() && this.hasFuelItemInSlot()) {
            this.startBurning();
        }
        if (this.isBurningFuel() && !storageFull) {
            int before = this.ENERGY_STORAGE.getEnergyStored();
            this.generateEnergyTick();
            ++this.burnTime;
            if (this.burnTime >= this.burnTimeTotal) {
                this.isBurning = false;
            }
            if (!level1.isClientSide && this.ENERGY_STORAGE.getEnergyStored() != before) {
                this.pushEnergyToNeighbors();
                this.setChanged();
                level1.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            }
        } else if (!this.isBurningFuel() && this.burnTime >= this.burnTimeTotal && this.burnTimeTotal > 0) {
            this.burnTime = 0;
            this.burnTimeTotal = 0;
        }
        if (!level1.isClientSide) {
            this.pushEnergyToNeighbors();
        }
    }

    private void pushEnergyToNeighbors() {
        if (this.ENERGY_STORAGE.getEnergyStored() <= 0 || this.level == null) {
            return;
        }
        for (Direction dir : Direction.values()) {
            float actuallyAccepted;
            float actuallyExtracted;
            float accepted;
            float offer;
            BlockPos neighborPos = this.worldPosition.relative(dir);
            IEnergyStorage target = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, (Object)dir.getOpposite());
            if (target == null) {
                target = (IEnergyStorage)this.level.getCapability(Capabilities.EnergyStorage.BLOCK, neighborPos, null);
            }
            if (target == null || (offer = Math.min(ENERGY_TRANSFER_RATE, (float)this.ENERGY_STORAGE.getEnergyStored())) <= 0.0f || (accepted = (float)target.receiveEnergy((int)offer, true)) <= 0.0f || (actuallyExtracted = (float)this.ENERGY_STORAGE.extractEnergy((int)accepted, false)) <= 0.0f || !((actuallyAccepted = (float)target.receiveEnergy((int)actuallyExtracted, false)) < actuallyExtracted)) continue;
            this.ENERGY_STORAGE.receiveEnergy((int)(actuallyExtracted - actuallyAccepted), false);
        }
    }

    private void finishBurning() {
        this.isBurning = false;
    }

    private boolean isBurningFuel() {
        return this.isBurning && this.burnTimeTotal > 0 && this.burnTime < this.burnTimeTotal;
    }

    private void startBurning() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            this.isBurning = false;
            return;
        }
        int burn = AbstractFurnaceBlockEntity.getFuel().getOrDefault(stack.getItem(), 0);
        if (burn <= 0) {
            this.isBurning = false;
            return;
        }
        this.itemHandler.extractItem(0, 1, false);
        this.burnTimeTotal = burn;
        this.burnTime = 0;
        this.isBurning = true;
        if (this.level != null && !this.level.isClientSide) {
            this.setChanged();
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }

    private boolean hasFuelItemInSlot() {
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            return false;
        }
        return AbstractFurnaceBlockEntity.getFuel().getOrDefault(stack.getItem(), 0) > 0;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        tag.put("generator.inventory", (Tag)this.itemHandler.serializeNBT(registries));
        tag.putInt("generator.burn_time", this.burnTime);
        tag.putInt("generator.burn_time_total", this.burnTimeTotal);
        tag.putBoolean("generator.is_burning", this.isBurning);
        tag.putInt("generator.energy", this.ENERGY_STORAGE.getEnergyStored());
        super.saveAdditional(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.itemHandler.deserializeNBT(registries, tag.getCompound("generator.inventory"));
        this.ENERGY_STORAGE.setEnergy(tag.getInt("generator.energy"));
        this.burnTime = tag.getInt("generator.burn_time");
        this.burnTimeTotal = tag.getInt("generator.burn_time_total");
        this.isBurning = tag.getBoolean("generator.is_burning");
        this.burnTime = this.burnTimeTotal > 0 ? Math.min(this.burnTime, this.burnTimeTotal) : 0;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        super.onDataPacket(net, pkt, lookupProvider);
    }
}

