/*
 * Decompiled with CFR 0.152.
 */
package net.cmr.jurassicrevived.compat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.cmr.jurassicrevived.Config;
import net.cmr.jurassicrevived.block.ModBlocks;
import net.cmr.jurassicrevived.compat.FluidStackSlotRenderer;
import net.cmr.jurassicrevived.recipe.FossilCleanerRecipe;
import net.cmr.jurassicrevived.screen.renderer.FluidTankRenderer;
import net.cmr.jurassicrevived.util.ModTags;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.Nullable;

public class FossilCleanerRecipeCategory
implements IRecipeCategory<FossilCleanerRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"fossil_cleaning");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/fossil_cleaner/fossil_cleaner_gui.png");
    public static final ResourceLocation ARROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/arrow.png");
    public static final ResourceLocation WHITE_ARROW_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/white_arrow.png");
    private static final ResourceLocation POWER_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"jurassicrevived", (String)"textures/gui/generic/power_bar.png");
    public static final RecipeType<FossilCleanerRecipe> FOSSIL_CLEANER_RECIPE_RECIPE_TYPE = new RecipeType(UID, FossilCleanerRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final FluidTankRenderer fluidRenderer;
    private static List<ItemStack> WATER_CONTAINERS_CACHE = null;

    public FossilCleanerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.drawableBuilder(TEXTURE, 0, 0, 176, 80).setTextureSize(176, 166).build();
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModBlocks.FOSSIL_CLEANER.get()));
        this.fluidRenderer = new FluidTankRenderer(16000L, true, 16, 50);
        if (WATER_CONTAINERS_CACHE == null) {
            WATER_CONTAINERS_CACHE = FossilCleanerRecipeCategory.buildWaterContainersList();
        }
    }

    public RecipeType<FossilCleanerRecipe> getRecipeType() {
        return FOSSIL_CLEANER_RECIPE_RECIPE_TYPE;
    }

    public Component getTitle() {
        return Component.translatable((String)"block.jurassicrevived.fossil_cleaner");
    }

    public int getWidth() {
        return this.background.getWidth();
    }

    public int getHeight() {
        return this.background.getHeight();
    }

    public void draw(FossilCleanerRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.background.draw(guiGraphics);
        guiGraphics.blit(ARROW_TEXTURE, 76, 35, 0.0f, 0.0f, 24, 16, 24, 16);
        if (Config.REQUIRE_POWER) {
            guiGraphics.blit(POWER_BAR_TEXTURE, 159, 10, 0.0f, 0.0f, 10, 66, 10, 66);
            int barX = 160;
            int barY = 11;
            int barW = 8;
            int barH = 64;
            int maxTicks = 200;
            long now = System.currentTimeMillis();
            int progress = (int)(now / 50L % (long)maxTicks);
            int arrowPixels = 24;
            int progFilled = progress * arrowPixels / maxTicks;
            if (progFilled > 0) {
                guiGraphics.blit(WHITE_ARROW_TEXTURE, 76, 35, 0.0f, 0.0f, progFilled, 16, 24, 16);
            }
            int requiredFE = 2000;
            int capacityFE = 16000;
            int filled = (int)((float)barH * ((float)requiredFE / (float)capacityFE));
            guiGraphics.fillGradient(barX, barY + (barH - filled), barX + barW, barY + barH, -4909824, -10482944);
            int mx = (int)mouseX;
            int my = (int)mouseY;
            if (mx >= barX && mx < barX + barW && my >= barY && my < barY + barH) {
                List<MutableComponent> tips = List.of(Component.literal((String)"2000 / 16000 FE"));
                guiGraphics.renderTooltip(Minecraft.getInstance().font, tips, Optional.empty(), mx, my);
            }
        }
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FossilCleanerRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 57, 35).addIngredients((Ingredient)recipe.getIngredients().get(0));
        IRecipeSlotBuilder tankSlot = builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 7, 8);
        tankSlot.addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)new FluidStack((Fluid)Fluids.WATER, 250));
        tankSlot.setCustomRenderer((IIngredientType)NeoForgeTypes.FLUID_STACK, (IIngredientRenderer)new FluidStackSlotRenderer(this.fluidRenderer));
        IRecipeSlotBuilder waterItems = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 7, 61).addItemStacks(WATER_CONTAINERS_CACHE);
        waterItems.addRichTooltipCallback((view, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)"jurassicrevived.tooltip.accepts_any_water_container")));
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            Registry itemRegistry = level.registryAccess().registryOrThrow(Registries.ITEM);
            Optional fossilsTagOpt = itemRegistry.getTag(ModTags.Items.FOSSILS);
            List fossilOutputs = fossilsTagOpt.map(holderSet -> holderSet.stream().map(h -> new ItemStack((ItemLike)h.value(), Math.max(1, recipe.getResultItem(null).getCount()))).collect(Collectors.toList())).orElse(List.of());
            IRecipeSlotBuilder slot = (IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 35).addItemStacks(fossilOutputs);
            slot.addRichTooltipCallback((view, tooltip) -> {
                Optional opt = view.getDisplayedItemStack();
                if (opt.isPresent()) {
                    int weight = recipe.getWeightFor(((ItemStack)opt.get()).getItem());
                    tooltip.add((FormattedText)Component.literal((String)("Weight: " + weight)));
                }
            });
            return;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 35).addItemStack(recipe.getResultItem(null));
    }

    private static List<ItemStack> buildWaterContainersList() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        list.add(new ItemStack((ItemLike)Items.WATER_BUCKET));
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        if (level == null) {
            return Collections.unmodifiableList(list);
        }
        int REQUIRED_MB = 250;
        Registry itemRegistry = level.registryAccess().registryOrThrow(Registries.ITEM);
        for (Item item : itemRegistry) {
            ItemStack empty;
            IFluidHandlerItem fh;
            if (item == Items.WATER_BUCKET || (fh = (IFluidHandlerItem)(empty = new ItemStack((ItemLike)item)).getCapability(Capabilities.FluidHandler.ITEM, null)) == null || fh.getTanks() <= 0) continue;
            boolean hasWaterNow = false;
            for (int t = 0; t < fh.getTanks(); ++t) {
                FluidStack fs = fh.getFluidInTank(t);
                if (fs.isEmpty() || !fs.getFluid().is(FluidTags.WATER)) continue;
                hasWaterNow = true;
                break;
            }
            if (hasWaterNow) {
                list.add(empty);
                continue;
            }
            ItemStack filled250 = FossilCleanerRecipeCategory.tryFillContainerWithWater(empty, 250);
            if (!filled250.isEmpty()) {
                list.add(filled250);
                continue;
            }
            ItemStack filledFull = FossilCleanerRecipeCategory.tryFillContainerWithWater(empty, Integer.MAX_VALUE);
            if (filledFull.isEmpty()) continue;
            list.add(filledFull);
        }
        return Collections.unmodifiableList(list);
    }

    private static ItemStack tryFillContainerWithWater(ItemStack empty, int amountMb) {
        ItemStack out;
        IFluidHandlerItem fh;
        if (amountMb <= 0) {
            return ItemStack.EMPTY;
        }
        int cap = amountMb == Integer.MAX_VALUE ? 0x1FFFFFFF : amountMb;
        FluidTank source = new FluidTank(cap){

            public boolean isFluidValid(FluidStack stack) {
                return stack.getFluid().is(FluidTags.WATER);
            }
        };
        int toInsert = amountMb == Integer.MAX_VALUE ? cap : amountMb;
        source.fill(new FluidStack((Fluid)Fluids.WATER, toInsert), IFluidHandler.FluidAction.EXECUTE);
        FluidActionResult res = FluidUtil.tryFillContainer((ItemStack)empty.copy(), (IFluidHandler)source, (int)Integer.MAX_VALUE, null, (boolean)true);
        if (res.isSuccess() && (fh = (IFluidHandlerItem)(out = res.getResult()).getCapability(Capabilities.FluidHandler.ITEM, null)) != null) {
            for (int t = 0; t < fh.getTanks(); ++t) {
                FluidStack fs = fh.getFluidInTank(t);
                if (fs.isEmpty() || !fs.getFluid().is(FluidTags.WATER)) continue;
                return out;
            }
        }
        return ItemStack.EMPTY;
    }
}

